/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the
 * location for your sample documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampleDocuments implements SdkPojo, Serializable, ToCopyableBuilder<SampleDocuments.Builder, SampleDocuments> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(SampleDocuments::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<List<SampleDocumentKeys>> KEYS_FIELD = SdkField
            .<List<SampleDocumentKeys>> builder(MarshallingType.LIST)
            .memberName("keys")
            .getter(getter(SampleDocuments::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleDocumentKeys> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleDocumentKeys::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final List<SampleDocumentKeys> keys;

    private SampleDocuments(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.keys = builder.keys;
    }

    /**
     * <p>
     * Contains the Amazon S3 bucket that is used to hold your sample documents.
     * </p>
     * 
     * @return Contains the Amazon S3 bucket that is used to hold your sample documents.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
     */
    public final List<SampleDocumentKeys> keys() {
        return keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleDocuments)) {
            return false;
        }
        SampleDocuments other = (SampleDocuments) obj;
        return Objects.equals(bucketName(), other.bucketName()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampleDocuments").add("BucketName", bucketName()).add("Keys", hasKeys() ? keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "keys":
            return Optional.ofNullable(clazz.cast(keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bucketName", BUCKET_NAME_FIELD);
        map.put("keys", KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SampleDocuments, T> g) {
        return obj -> g.apply((SampleDocuments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SampleDocuments> {
        /**
         * <p>
         * Contains the Amazon S3 bucket that is used to hold your sample documents.
         * </p>
         * 
         * @param bucketName
         *        Contains the Amazon S3 bucket that is used to hold your sample documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * </p>
         * 
         * @param keys
         *        Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<SampleDocumentKeys> keys);

        /**
         * <p>
         * Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * </p>
         * 
         * @param keys
         *        Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(SampleDocumentKeys... keys);

        /**
         * <p>
         * Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.SampleDocumentKeys.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.SampleDocumentKeys#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.SampleDocumentKeys.Builder#build()} is called immediately
         * and its result is passed to {@link #keys(List<SampleDocumentKeys>)}.
         * 
         * @param keys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.SampleDocumentKeys.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keys(java.util.Collection<SampleDocumentKeys>)
         */
        Builder keys(Consumer<SampleDocumentKeys.Builder>... keys);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private List<SampleDocumentKeys> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SampleDocuments model) {
            bucketName(model.bucketName);
            keys(model.keys);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final List<SampleDocumentKeys.Builder> getKeys() {
            List<SampleDocumentKeys.Builder> result = KeyListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeys(Collection<SampleDocumentKeys.BuilderImpl> keys) {
            this.keys = KeyListCopier.copyFromBuilder(keys);
        }

        @Override
        public final Builder keys(Collection<SampleDocumentKeys> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(SampleDocumentKeys... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<SampleDocumentKeys.Builder>... keys) {
            keys(Stream.of(keys).map(c -> SampleDocumentKeys.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SampleDocuments build() {
            return new SampleDocuments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
