/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTransformerJobResponse extends B2BiResponse implements
        ToCopyableBuilder<StartTransformerJobResponse.Builder, StartTransformerJobResponse> {
    private static final SdkField<String> TRANSFORMER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerJobId").getter(getter(StartTransformerJobResponse::transformerJobId))
            .setter(setter(Builder::transformerJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_JOB_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transformerJobId;

    private StartTransformerJobResponse(BuilderImpl builder) {
        super(builder);
        this.transformerJobId = builder.transformerJobId;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for a transformer run.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for a transformer run.
     */
    public final String transformerJobId() {
        return transformerJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformerJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTransformerJobResponse)) {
            return false;
        }
        StartTransformerJobResponse other = (StartTransformerJobResponse) obj;
        return Objects.equals(transformerJobId(), other.transformerJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTransformerJobResponse").add("TransformerJobId", transformerJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformerJobId":
            return Optional.ofNullable(clazz.cast(transformerJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformerJobId", TRANSFORMER_JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTransformerJobResponse, T> g) {
        return obj -> g.apply((StartTransformerJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartTransformerJobResponse> {
        /**
         * <p>
         * Returns the unique, system-generated identifier for a transformer run.
         * </p>
         * 
         * @param transformerJobId
         *        Returns the unique, system-generated identifier for a transformer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerJobId(String transformerJobId);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String transformerJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTransformerJobResponse model) {
            super(model);
            transformerJobId(model.transformerJobId);
        }

        public final String getTransformerJobId() {
            return transformerJobId;
        }

        public final void setTransformerJobId(String transformerJobId) {
            this.transformerJobId = transformerJobId;
        }

        @Override
        public final Builder transformerJobId(String transformerJobId) {
            this.transformerJobId = transformerJobId;
            return this;
        }

        @Override
        public StartTransformerJobResponse build() {
            return new StartTransformerJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
