/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileRequest extends B2BiRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(UpdateProfileRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(UpdateProfileRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phone")
            .getter(getter(UpdateProfileRequest::phone)).setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessName").getter(getter(UpdateProfileRequest::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, NAME_FIELD,
            EMAIL_FIELD, PHONE_FIELD, BUSINESS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileId;

    private final String name;

    private final String email;

    private final String phone;

    private final String businessName;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.businessName = builder.businessName;
    }

    /**
     * <p>
     * Specifies the unique, system-generated identifier for the profile.
     * </p>
     * 
     * @return Specifies the unique, system-generated identifier for the profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The name of the profile, used to identify it.
     * </p>
     * 
     * @return The name of the profile, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the email address associated with this customer profile.
     * </p>
     * 
     * @return Specifies the email address associated with this customer profile.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Specifies the phone number associated with the profile.
     * </p>
     * 
     * @return Specifies the phone number associated with the profile.
     */
    public final String phone() {
        return phone;
    }

    /**
     * <p>
     * Specifies the name for the business associated with this profile.
     * </p>
     * 
     * @return Specifies the name for the business associated with this profile.
     */
    public final String businessName() {
        return businessName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(phone());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email()) && Objects.equals(phone(), other.phone())
                && Objects.equals(businessName(), other.businessName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileRequest").add("ProfileId", profileId()).add("Name", name())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Phone", phone() == null ? null : "*** Sensitive Data Redacted ***").add("BusinessName", businessName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "phone":
            return Optional.ofNullable(clazz.cast(phone()));
        case "businessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("phone", PHONE_FIELD);
        map.put("businessName", BUSINESS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * Specifies the unique, system-generated identifier for the profile.
         * </p>
         * 
         * @param profileId
         *        Specifies the unique, system-generated identifier for the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The name of the profile, used to identify it.
         * </p>
         * 
         * @param name
         *        The name of the profile, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the email address associated with this customer profile.
         * </p>
         * 
         * @param email
         *        Specifies the email address associated with this customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Specifies the phone number associated with the profile.
         * </p>
         * 
         * @param phone
         *        Specifies the phone number associated with the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(String phone);

        /**
         * <p>
         * Specifies the name for the business associated with this profile.
         * </p>
         * 
         * @param businessName
         *        Specifies the name for the business associated with this profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String profileId;

        private String name;

        private String email;

        private String phone;

        private String businessName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            profileId(model.profileId);
            name(model.name);
            email(model.email);
            phone(model.phone);
            businessName(model.businessName);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
