/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTransformerRequest extends B2BiRequest implements
        ToCopyableBuilder<UpdateTransformerRequest.Builder, UpdateTransformerRequest> {
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerId").getter(getter(UpdateTransformerRequest::transformerId))
            .setter(setter(Builder::transformerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateTransformerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateTransformerRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(UpdateTransformerRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(UpdateTransformerRequest::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO)
            .memberName("ediType").getter(getter(UpdateTransformerRequest::ediType)).setter(setter(Builder::ediType))
            .constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()).build();

    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleDocument").getter(getter(UpdateTransformerRequest::sampleDocument))
            .setter(setter(Builder::sampleDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()).build();

    private static final SdkField<InputConversion> INPUT_CONVERSION_FIELD = SdkField
            .<InputConversion> builder(MarshallingType.SDK_POJO).memberName("inputConversion")
            .getter(getter(UpdateTransformerRequest::inputConversion)).setter(setter(Builder::inputConversion))
            .constructor(InputConversion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConversion").build()).build();

    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.<Mapping> builder(MarshallingType.SDK_POJO)
            .memberName("mapping").getter(getter(UpdateTransformerRequest::mapping)).setter(setter(Builder::mapping))
            .constructor(Mapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapping").build()).build();

    private static final SdkField<OutputConversion> OUTPUT_CONVERSION_FIELD = SdkField
            .<OutputConversion> builder(MarshallingType.SDK_POJO).memberName("outputConversion")
            .getter(getter(UpdateTransformerRequest::outputConversion)).setter(setter(Builder::outputConversion))
            .constructor(OutputConversion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConversion").build()).build();

    private static final SdkField<SampleDocuments> SAMPLE_DOCUMENTS_FIELD = SdkField
            .<SampleDocuments> builder(MarshallingType.SDK_POJO).memberName("sampleDocuments")
            .getter(getter(UpdateTransformerRequest::sampleDocuments)).setter(setter(Builder::sampleDocuments))
            .constructor(SampleDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocuments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_ID_FIELD,
            NAME_FIELD, STATUS_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD,
            INPUT_CONVERSION_FIELD, MAPPING_FIELD, OUTPUT_CONVERSION_FIELD, SAMPLE_DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transformerId;

    private final String name;

    private final String status;

    private final String fileFormat;

    private final String mappingTemplate;

    private final EdiType ediType;

    private final String sampleDocument;

    private final InputConversion inputConversion;

    private final Mapping mapping;

    private final OutputConversion outputConversion;

    private final SampleDocuments sampleDocuments;

    private UpdateTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.transformerId = builder.transformerId;
        this.name = builder.name;
        this.status = builder.status;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.inputConversion = builder.inputConversion;
        this.mapping = builder.mapping;
        this.outputConversion = builder.outputConversion;
        this.sampleDocuments = builder.sampleDocuments;
    }

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Specifies the system-assigned unique identifier for the transformer.
     */
    public final String transformerId() {
        return transformerId;
    }

    /**
     * <p>
     * Specify a new name for the transformer, if you want to update it.
     * </p>
     * 
     * @return Specify a new name for the transformer, if you want to update it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the transformer's status. You can update the state of the transformer from <code>inactive</code> to
     * <code>active</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the transformer's status. You can update the state of the transformer from
     *         <code>inactive</code> to <code>active</code>.
     * @see TransformerStatus
     */
    public final TransformerStatus status() {
        return TransformerStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the transformer's status. You can update the state of the transformer from <code>inactive</code> to
     * <code>active</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the transformer's status. You can update the state of the transformer from
     *         <code>inactive</code> to <code>active</code>.
     * @see TransformerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
     * JSONata or XSLT.
     * </p>
     * <note>
     * <p>
     * This parameter is available for backwards compatibility. Use the <a
     * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type instead.
     * </p>
     * </note>
     * 
     * @return Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
     *         using JSONata or XSLT.</p> <note>
     *         <p>
     *         This parameter is available for backwards compatibility. Use the <a
     *         href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type
     *         instead.
     *         </p>
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final EdiType ediType() {
        return ediType;
    }

    /**
     * <p>
     * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @return Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String sampleDocument() {
        return sampleDocument;
    }

    /**
     * <p>
     * To update, specify the <code>InputConversion</code> object, which contains the format options for the inbound
     * transformation.
     * </p>
     * 
     * @return To update, specify the <code>InputConversion</code> object, which contains the format options for the
     *         inbound transformation.
     */
    public final InputConversion inputConversion() {
        return inputConversion;
    }

    /**
     * <p>
     * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
     * </p>
     * 
     * @return Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    public final Mapping mapping() {
        return mapping;
    }

    /**
     * <p>
     * To update, specify the <code>OutputConversion</code> object, which contains the format options for the outbound
     * transformation.
     * </p>
     * 
     * @return To update, specify the <code>OutputConversion</code> object, which contains the format options for the
     *         outbound transformation.
     */
    public final OutputConversion outputConversion() {
        return outputConversion;
    }

    /**
     * <p>
     * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify
     * the location for your sample documents.
     * </p>
     * 
     * @return Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
     *         identify the location for your sample documents.
     */
    public final SampleDocuments sampleDocuments() {
        return sampleDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(ediType());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(inputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(mapping());
        hashCode = 31 * hashCode + Objects.hashCode(outputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocuments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTransformerRequest)) {
            return false;
        }
        UpdateTransformerRequest other = (UpdateTransformerRequest) obj;
        return Objects.equals(transformerId(), other.transformerId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(mappingTemplate(), other.mappingTemplate()) && Objects.equals(ediType(), other.ediType())
                && Objects.equals(sampleDocument(), other.sampleDocument())
                && Objects.equals(inputConversion(), other.inputConversion()) && Objects.equals(mapping(), other.mapping())
                && Objects.equals(outputConversion(), other.outputConversion())
                && Objects.equals(sampleDocuments(), other.sampleDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTransformerRequest").add("TransformerId", transformerId()).add("Name", name())
                .add("Status", statusAsString()).add("FileFormat", fileFormatAsString())
                .add("MappingTemplate", mappingTemplate()).add("EdiType", ediType()).add("SampleDocument", sampleDocument())
                .add("InputConversion", inputConversion()).add("Mapping", mapping()).add("OutputConversion", outputConversion())
                .add("SampleDocuments", sampleDocuments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformerId":
            return Optional.ofNullable(clazz.cast(transformerId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "ediType":
            return Optional.ofNullable(clazz.cast(ediType()));
        case "sampleDocument":
            return Optional.ofNullable(clazz.cast(sampleDocument()));
        case "inputConversion":
            return Optional.ofNullable(clazz.cast(inputConversion()));
        case "mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        case "outputConversion":
            return Optional.ofNullable(clazz.cast(outputConversion()));
        case "sampleDocuments":
            return Optional.ofNullable(clazz.cast(sampleDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformerId", TRANSFORMER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        map.put("ediType", EDI_TYPE_FIELD);
        map.put("sampleDocument", SAMPLE_DOCUMENT_FIELD);
        map.put("inputConversion", INPUT_CONVERSION_FIELD);
        map.put("mapping", MAPPING_FIELD);
        map.put("outputConversion", OUTPUT_CONVERSION_FIELD);
        map.put("sampleDocuments", SAMPLE_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTransformerRequest, T> g) {
        return obj -> g.apply((UpdateTransformerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTransformerRequest> {
        /**
         * <p>
         * Specifies the system-assigned unique identifier for the transformer.
         * </p>
         * 
         * @param transformerId
         *        Specifies the system-assigned unique identifier for the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerId(String transformerId);

        /**
         * <p>
         * Specify a new name for the transformer, if you want to update it.
         * </p>
         * 
         * @param name
         *        Specify a new name for the transformer, if you want to update it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the transformer's status. You can update the state of the transformer from <code>inactive</code> to
         * <code>active</code>.
         * </p>
         * 
         * @param status
         *        Specifies the transformer's status. You can update the state of the transformer from
         *        <code>inactive</code> to <code>active</code>.
         * @see TransformerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the transformer's status. You can update the state of the transformer from <code>inactive</code> to
         * <code>active</code>.
         * </p>
         * 
         * @param status
         *        Specifies the transformer's status. You can update the state of the transformer from
         *        <code>inactive</code> to <code>active</code>.
         * @see TransformerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerStatus
         */
        Builder status(TransformerStatus status);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
         * JSONata or XSLT.
         * </p>
         * <note>
         * <p>
         * This parameter is available for backwards compatibility. Use the <a
         * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type instead.
         * </p>
         * </note>
         * 
         * @param mappingTemplate
         *        Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
         *        using JSONata or XSLT.</p> <note>
         *        <p>
         *        This parameter is available for backwards compatibility. Use the <a
         *        href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type
         *        instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param ediType
         *        Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder ediType(EdiType ediType);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #ediType(EdiType)}.
         * 
         * @param ediType
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediType(EdiType)
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        default Builder ediType(Consumer<EdiType.Builder> ediType) {
            return ediType(EdiType.builder().applyMutation(ediType).build());
        }

        /**
         * <p>
         * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * </p>
         * 
         * @param sampleDocument
         *        Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder sampleDocument(String sampleDocument);

        /**
         * <p>
         * To update, specify the <code>InputConversion</code> object, which contains the format options for the inbound
         * transformation.
         * </p>
         * 
         * @param inputConversion
         *        To update, specify the <code>InputConversion</code> object, which contains the format options for the
         *        inbound transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConversion(InputConversion inputConversion);

        /**
         * <p>
         * To update, specify the <code>InputConversion</code> object, which contains the format options for the inbound
         * transformation.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConversion.Builder} avoiding the
         * need to create one manually via {@link InputConversion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConversion.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConversion(InputConversion)}.
         * 
         * @param inputConversion
         *        a consumer that will call methods on {@link InputConversion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConversion(InputConversion)
         */
        default Builder inputConversion(Consumer<InputConversion.Builder> inputConversion) {
            return inputConversion(InputConversion.builder().applyMutation(inputConversion).build());
        }

        /**
         * <p>
         * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * </p>
         * 
         * @param mapping
         *        Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Mapping mapping);

        /**
         * <p>
         * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * </p>
         * This is a convenience method that creates an instance of the {@link Mapping.Builder} avoiding the need to
         * create one manually via {@link Mapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mapping.Builder#build()} is called immediately and its result is
         * passed to {@link #mapping(Mapping)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link Mapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(Mapping)
         */
        default Builder mapping(Consumer<Mapping.Builder> mapping) {
            return mapping(Mapping.builder().applyMutation(mapping).build());
        }

        /**
         * <p>
         * To update, specify the <code>OutputConversion</code> object, which contains the format options for the
         * outbound transformation.
         * </p>
         * 
         * @param outputConversion
         *        To update, specify the <code>OutputConversion</code> object, which contains the format options for the
         *        outbound transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConversion(OutputConversion outputConversion);

        /**
         * <p>
         * To update, specify the <code>OutputConversion</code> object, which contains the format options for the
         * outbound transformation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConversion.Builder} avoiding the
         * need to create one manually via {@link OutputConversion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConversion.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConversion(OutputConversion)}.
         * 
         * @param outputConversion
         *        a consumer that will call methods on {@link OutputConversion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConversion(OutputConversion)
         */
        default Builder outputConversion(Consumer<OutputConversion.Builder> outputConversion) {
            return outputConversion(OutputConversion.builder().applyMutation(outputConversion).build());
        }

        /**
         * <p>
         * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         * identify the location for your sample documents.
         * </p>
         * 
         * @param sampleDocuments
         *        Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         *        identify the location for your sample documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleDocuments(SampleDocuments sampleDocuments);

        /**
         * <p>
         * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         * identify the location for your sample documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link SampleDocuments.Builder} avoiding the
         * need to create one manually via {@link SampleDocuments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SampleDocuments.Builder#build()} is called immediately and its
         * result is passed to {@link #sampleDocuments(SampleDocuments)}.
         * 
         * @param sampleDocuments
         *        a consumer that will call methods on {@link SampleDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleDocuments(SampleDocuments)
         */
        default Builder sampleDocuments(Consumer<SampleDocuments.Builder> sampleDocuments) {
            return sampleDocuments(SampleDocuments.builder().applyMutation(sampleDocuments).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String transformerId;

        private String name;

        private String status;

        private String fileFormat;

        private String mappingTemplate;

        private EdiType ediType;

        private String sampleDocument;

        private InputConversion inputConversion;

        private Mapping mapping;

        private OutputConversion outputConversion;

        private SampleDocuments sampleDocuments;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTransformerRequest model) {
            super(model);
            transformerId(model.transformerId);
            name(model.name);
            status(model.status);
            fileFormat(model.fileFormat);
            mappingTemplate(model.mappingTemplate);
            ediType(model.ediType);
            sampleDocument(model.sampleDocument);
            inputConversion(model.inputConversion);
            mapping(model.mapping);
            outputConversion(model.outputConversion);
            sampleDocuments(model.sampleDocuments);
        }

        public final String getTransformerId() {
            return transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final String getFileFormat() {
            return fileFormat;
        }

        @Deprecated
        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Deprecated
        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        @Deprecated
        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        @Deprecated
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        @Deprecated
        public final EdiType.Builder getEdiType() {
            return ediType != null ? ediType.toBuilder() : null;
        }

        @Deprecated
        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        @Deprecated
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Deprecated
        public final String getSampleDocument() {
            return sampleDocument;
        }

        @Deprecated
        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        @Deprecated
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final InputConversion.Builder getInputConversion() {
            return inputConversion != null ? inputConversion.toBuilder() : null;
        }

        public final void setInputConversion(InputConversion.BuilderImpl inputConversion) {
            this.inputConversion = inputConversion != null ? inputConversion.build() : null;
        }

        @Override
        public final Builder inputConversion(InputConversion inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        public final Mapping.Builder getMapping() {
            return mapping != null ? mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public final OutputConversion.Builder getOutputConversion() {
            return outputConversion != null ? outputConversion.toBuilder() : null;
        }

        public final void setOutputConversion(OutputConversion.BuilderImpl outputConversion) {
            this.outputConversion = outputConversion != null ? outputConversion.build() : null;
        }

        @Override
        public final Builder outputConversion(OutputConversion outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        public final SampleDocuments.Builder getSampleDocuments() {
            return sampleDocuments != null ? sampleDocuments.toBuilder() : null;
        }

        public final void setSampleDocuments(SampleDocuments.BuilderImpl sampleDocuments) {
            this.sampleDocuments = sampleDocuments != null ? sampleDocuments.build() : null;
        }

        @Override
        public final Builder sampleDocuments(SampleDocuments sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTransformerRequest build() {
            return new UpdateTransformerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
