/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper structure for an X12 definition object.
 * </p>
 * <p>
 * the X12 envelope ensures the integrity of the data and the efficiency of the information exchange. The X12 message
 * structure has hierarchical levels. From highest to the lowest, they are:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Interchange Envelope
 * </p>
 * </li>
 * <li>
 * <p>
 * Functional Group
 * </p>
 * </li>
 * <li>
 * <p>
 * Transaction Set
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12Envelope implements SdkPojo, Serializable, ToCopyableBuilder<X12Envelope.Builder, X12Envelope> {
    private static final SdkField<X12OutboundEdiHeaders> COMMON_FIELD = SdkField
            .<X12OutboundEdiHeaders> builder(MarshallingType.SDK_POJO).memberName("common").getter(getter(X12Envelope::common))
            .setter(setter(Builder::common)).constructor(X12OutboundEdiHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("common").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12OutboundEdiHeaders common;

    private X12Envelope(BuilderImpl builder) {
        this.common = builder.common;
    }

    /**
     * <p>
     * A container for the X12 outbound EDI headers.
     * </p>
     * 
     * @return A container for the X12 outbound EDI headers.
     */
    public final X12OutboundEdiHeaders common() {
        return common;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(common());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12Envelope)) {
            return false;
        }
        X12Envelope other = (X12Envelope) obj;
        return Objects.equals(common(), other.common());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12Envelope").add("Common", common()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "common":
            return Optional.ofNullable(clazz.cast(common()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("common", COMMON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12Envelope, T> g) {
        return obj -> g.apply((X12Envelope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12Envelope> {
        /**
         * <p>
         * A container for the X12 outbound EDI headers.
         * </p>
         * 
         * @param common
         *        A container for the X12 outbound EDI headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder common(X12OutboundEdiHeaders common);

        /**
         * <p>
         * A container for the X12 outbound EDI headers.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12OutboundEdiHeaders.Builder} avoiding
         * the need to create one manually via {@link X12OutboundEdiHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12OutboundEdiHeaders.Builder#build()} is called immediately and
         * its result is passed to {@link #common(X12OutboundEdiHeaders)}.
         * 
         * @param common
         *        a consumer that will call methods on {@link X12OutboundEdiHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #common(X12OutboundEdiHeaders)
         */
        default Builder common(Consumer<X12OutboundEdiHeaders.Builder> common) {
            return common(X12OutboundEdiHeaders.builder().applyMutation(common).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12OutboundEdiHeaders common;

        private BuilderImpl() {
        }

        private BuilderImpl(X12Envelope model) {
            common(model.common);
        }

        public final X12OutboundEdiHeaders.Builder getCommon() {
            return common != null ? common.toBuilder() : null;
        }

        public final void setCommon(X12OutboundEdiHeaders.BuilderImpl common) {
            this.common = common != null ? common.build() : null;
        }

        @Override
        public final Builder common(X12OutboundEdiHeaders common) {
            this.common = common;
            return this;
        }

        @Override
        public X12Envelope build() {
            return new X12Envelope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
