/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of the X12 message structure. These are the functional group headers for the X12 EDI object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12FunctionalGroupHeaders implements SdkPojo, Serializable,
        ToCopyableBuilder<X12FunctionalGroupHeaders.Builder, X12FunctionalGroupHeaders> {
    private static final SdkField<String> APPLICATION_SENDER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationSenderCode").getter(getter(X12FunctionalGroupHeaders::applicationSenderCode))
            .setter(setter(Builder::applicationSenderCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationSenderCode").build())
            .build();

    private static final SdkField<String> APPLICATION_RECEIVER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationReceiverCode").getter(getter(X12FunctionalGroupHeaders::applicationReceiverCode))
            .setter(setter(Builder::applicationReceiverCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationReceiverCode").build())
            .build();

    private static final SdkField<String> RESPONSIBLE_AGENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responsibleAgencyCode").getter(getter(X12FunctionalGroupHeaders::responsibleAgencyCode))
            .setter(setter(Builder::responsibleAgencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsibleAgencyCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SENDER_CODE_FIELD,
            APPLICATION_RECEIVER_CODE_FIELD, RESPONSIBLE_AGENCY_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationSenderCode;

    private final String applicationReceiverCode;

    private final String responsibleAgencyCode;

    private X12FunctionalGroupHeaders(BuilderImpl builder) {
        this.applicationSenderCode = builder.applicationSenderCode;
        this.applicationReceiverCode = builder.applicationReceiverCode;
        this.responsibleAgencyCode = builder.responsibleAgencyCode;
    }

    /**
     * <p>
     * A value representing the code used to identify the party transmitting a message, at position GS-02.
     * </p>
     * 
     * @return A value representing the code used to identify the party transmitting a message, at position GS-02.
     */
    public final String applicationSenderCode() {
        return applicationSenderCode;
    }

    /**
     * <p>
     * A value representing the code used to identify the party receiving a message, at position GS-03.
     * </p>
     * 
     * @return A value representing the code used to identify the party receiving a message, at position GS-03.
     */
    public final String applicationReceiverCode() {
        return applicationReceiverCode;
    }

    /**
     * <p>
     * A code that identifies the issuer of the standard, at position GS-07.
     * </p>
     * 
     * @return A code that identifies the issuer of the standard, at position GS-07.
     */
    public final String responsibleAgencyCode() {
        return responsibleAgencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationSenderCode());
        hashCode = 31 * hashCode + Objects.hashCode(applicationReceiverCode());
        hashCode = 31 * hashCode + Objects.hashCode(responsibleAgencyCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12FunctionalGroupHeaders)) {
            return false;
        }
        X12FunctionalGroupHeaders other = (X12FunctionalGroupHeaders) obj;
        return Objects.equals(applicationSenderCode(), other.applicationSenderCode())
                && Objects.equals(applicationReceiverCode(), other.applicationReceiverCode())
                && Objects.equals(responsibleAgencyCode(), other.responsibleAgencyCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12FunctionalGroupHeaders").add("ApplicationSenderCode", applicationSenderCode())
                .add("ApplicationReceiverCode", applicationReceiverCode()).add("ResponsibleAgencyCode", responsibleAgencyCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationSenderCode":
            return Optional.ofNullable(clazz.cast(applicationSenderCode()));
        case "applicationReceiverCode":
            return Optional.ofNullable(clazz.cast(applicationReceiverCode()));
        case "responsibleAgencyCode":
            return Optional.ofNullable(clazz.cast(responsibleAgencyCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationSenderCode", APPLICATION_SENDER_CODE_FIELD);
        map.put("applicationReceiverCode", APPLICATION_RECEIVER_CODE_FIELD);
        map.put("responsibleAgencyCode", RESPONSIBLE_AGENCY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12FunctionalGroupHeaders, T> g) {
        return obj -> g.apply((X12FunctionalGroupHeaders) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12FunctionalGroupHeaders> {
        /**
         * <p>
         * A value representing the code used to identify the party transmitting a message, at position GS-02.
         * </p>
         * 
         * @param applicationSenderCode
         *        A value representing the code used to identify the party transmitting a message, at position GS-02.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSenderCode(String applicationSenderCode);

        /**
         * <p>
         * A value representing the code used to identify the party receiving a message, at position GS-03.
         * </p>
         * 
         * @param applicationReceiverCode
         *        A value representing the code used to identify the party receiving a message, at position GS-03.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationReceiverCode(String applicationReceiverCode);

        /**
         * <p>
         * A code that identifies the issuer of the standard, at position GS-07.
         * </p>
         * 
         * @param responsibleAgencyCode
         *        A code that identifies the issuer of the standard, at position GS-07.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responsibleAgencyCode(String responsibleAgencyCode);
    }

    static final class BuilderImpl implements Builder {
        private String applicationSenderCode;

        private String applicationReceiverCode;

        private String responsibleAgencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(X12FunctionalGroupHeaders model) {
            applicationSenderCode(model.applicationSenderCode);
            applicationReceiverCode(model.applicationReceiverCode);
            responsibleAgencyCode(model.responsibleAgencyCode);
        }

        public final String getApplicationSenderCode() {
            return applicationSenderCode;
        }

        public final void setApplicationSenderCode(String applicationSenderCode) {
            this.applicationSenderCode = applicationSenderCode;
        }

        @Override
        public final Builder applicationSenderCode(String applicationSenderCode) {
            this.applicationSenderCode = applicationSenderCode;
            return this;
        }

        public final String getApplicationReceiverCode() {
            return applicationReceiverCode;
        }

        public final void setApplicationReceiverCode(String applicationReceiverCode) {
            this.applicationReceiverCode = applicationReceiverCode;
        }

        @Override
        public final Builder applicationReceiverCode(String applicationReceiverCode) {
            this.applicationReceiverCode = applicationReceiverCode;
            return this;
        }

        public final String getResponsibleAgencyCode() {
            return responsibleAgencyCode;
        }

        public final void setResponsibleAgencyCode(String responsibleAgencyCode) {
            this.responsibleAgencyCode = responsibleAgencyCode;
        }

        @Override
        public final Builder responsibleAgencyCode(String responsibleAgencyCode) {
            this.responsibleAgencyCode = responsibleAgencyCode;
            return this;
        }

        @Override
        public X12FunctionalGroupHeaders build() {
            return new X12FunctionalGroupHeaders(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
