/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the details for an outbound EDI object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12OutboundEdiHeaders implements SdkPojo, Serializable,
        ToCopyableBuilder<X12OutboundEdiHeaders.Builder, X12OutboundEdiHeaders> {
    private static final SdkField<X12InterchangeControlHeaders> INTERCHANGE_CONTROL_HEADERS_FIELD = SdkField
            .<X12InterchangeControlHeaders> builder(MarshallingType.SDK_POJO).memberName("interchangeControlHeaders")
            .getter(getter(X12OutboundEdiHeaders::interchangeControlHeaders)).setter(setter(Builder::interchangeControlHeaders))
            .constructor(X12InterchangeControlHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interchangeControlHeaders").build())
            .build();

    private static final SdkField<X12FunctionalGroupHeaders> FUNCTIONAL_GROUP_HEADERS_FIELD = SdkField
            .<X12FunctionalGroupHeaders> builder(MarshallingType.SDK_POJO).memberName("functionalGroupHeaders")
            .getter(getter(X12OutboundEdiHeaders::functionalGroupHeaders)).setter(setter(Builder::functionalGroupHeaders))
            .constructor(X12FunctionalGroupHeaders::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionalGroupHeaders").build())
            .build();

    private static final SdkField<X12Delimiters> DELIMITERS_FIELD = SdkField.<X12Delimiters> builder(MarshallingType.SDK_POJO)
            .memberName("delimiters").getter(getter(X12OutboundEdiHeaders::delimiters)).setter(setter(Builder::delimiters))
            .constructor(X12Delimiters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimiters").build()).build();

    private static final SdkField<Boolean> VALIDATE_EDI_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("validateEdi").getter(getter(X12OutboundEdiHeaders::validateEdi)).setter(setter(Builder::validateEdi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateEdi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTERCHANGE_CONTROL_HEADERS_FIELD, FUNCTIONAL_GROUP_HEADERS_FIELD, DELIMITERS_FIELD, VALIDATE_EDI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12InterchangeControlHeaders interchangeControlHeaders;

    private final X12FunctionalGroupHeaders functionalGroupHeaders;

    private final X12Delimiters delimiters;

    private final Boolean validateEdi;

    private X12OutboundEdiHeaders(BuilderImpl builder) {
        this.interchangeControlHeaders = builder.interchangeControlHeaders;
        this.functionalGroupHeaders = builder.functionalGroupHeaders;
        this.delimiters = builder.delimiters;
        this.validateEdi = builder.validateEdi;
    }

    /**
     * <p>
     * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the
     * interchange control header.
     * </p>
     * 
     * @return In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the
     *         interchange control header.
     */
    public final X12InterchangeControlHeaders interchangeControlHeaders() {
        return interchangeControlHeaders;
    }

    /**
     * <p>
     * The functional group headers for the X12 object.
     * </p>
     * 
     * @return The functional group headers for the X12 object.
     */
    public final X12FunctionalGroupHeaders functionalGroupHeaders() {
        return functionalGroupHeaders;
    }

    /**
     * <p>
     * The delimiters, for example semicolon (<code>;</code>), that separates sections of the headers for the X12
     * object.
     * </p>
     * 
     * @return The delimiters, for example semicolon (<code>;</code>), that separates sections of the headers for the
     *         X12 object.
     */
    public final X12Delimiters delimiters() {
        return delimiters;
    }

    /**
     * <p>
     * Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code>.
     * </p>
     * 
     * @return Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code>
     *         .
     */
    public final Boolean validateEdi() {
        return validateEdi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interchangeControlHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(functionalGroupHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(delimiters());
        hashCode = 31 * hashCode + Objects.hashCode(validateEdi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12OutboundEdiHeaders)) {
            return false;
        }
        X12OutboundEdiHeaders other = (X12OutboundEdiHeaders) obj;
        return Objects.equals(interchangeControlHeaders(), other.interchangeControlHeaders())
                && Objects.equals(functionalGroupHeaders(), other.functionalGroupHeaders())
                && Objects.equals(delimiters(), other.delimiters()) && Objects.equals(validateEdi(), other.validateEdi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12OutboundEdiHeaders").add("InterchangeControlHeaders", interchangeControlHeaders())
                .add("FunctionalGroupHeaders", functionalGroupHeaders()).add("Delimiters", delimiters())
                .add("ValidateEdi", validateEdi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "interchangeControlHeaders":
            return Optional.ofNullable(clazz.cast(interchangeControlHeaders()));
        case "functionalGroupHeaders":
            return Optional.ofNullable(clazz.cast(functionalGroupHeaders()));
        case "delimiters":
            return Optional.ofNullable(clazz.cast(delimiters()));
        case "validateEdi":
            return Optional.ofNullable(clazz.cast(validateEdi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("interchangeControlHeaders", INTERCHANGE_CONTROL_HEADERS_FIELD);
        map.put("functionalGroupHeaders", FUNCTIONAL_GROUP_HEADERS_FIELD);
        map.put("delimiters", DELIMITERS_FIELD);
        map.put("validateEdi", VALIDATE_EDI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12OutboundEdiHeaders, T> g) {
        return obj -> g.apply((X12OutboundEdiHeaders) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12OutboundEdiHeaders> {
        /**
         * <p>
         * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the
         * interchange control header.
         * </p>
         * 
         * @param interchangeControlHeaders
         *        In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in
         *        the interchange control header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interchangeControlHeaders(X12InterchangeControlHeaders interchangeControlHeaders);

        /**
         * <p>
         * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the
         * interchange control header.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12InterchangeControlHeaders.Builder}
         * avoiding the need to create one manually via {@link X12InterchangeControlHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12InterchangeControlHeaders.Builder#build()} is called
         * immediately and its result is passed to {@link #interchangeControlHeaders(X12InterchangeControlHeaders)}.
         * 
         * @param interchangeControlHeaders
         *        a consumer that will call methods on {@link X12InterchangeControlHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interchangeControlHeaders(X12InterchangeControlHeaders)
         */
        default Builder interchangeControlHeaders(Consumer<X12InterchangeControlHeaders.Builder> interchangeControlHeaders) {
            return interchangeControlHeaders(X12InterchangeControlHeaders.builder().applyMutation(interchangeControlHeaders)
                    .build());
        }

        /**
         * <p>
         * The functional group headers for the X12 object.
         * </p>
         * 
         * @param functionalGroupHeaders
         *        The functional group headers for the X12 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionalGroupHeaders(X12FunctionalGroupHeaders functionalGroupHeaders);

        /**
         * <p>
         * The functional group headers for the X12 object.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12FunctionalGroupHeaders.Builder}
         * avoiding the need to create one manually via {@link X12FunctionalGroupHeaders#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12FunctionalGroupHeaders.Builder#build()} is called immediately
         * and its result is passed to {@link #functionalGroupHeaders(X12FunctionalGroupHeaders)}.
         * 
         * @param functionalGroupHeaders
         *        a consumer that will call methods on {@link X12FunctionalGroupHeaders.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionalGroupHeaders(X12FunctionalGroupHeaders)
         */
        default Builder functionalGroupHeaders(Consumer<X12FunctionalGroupHeaders.Builder> functionalGroupHeaders) {
            return functionalGroupHeaders(X12FunctionalGroupHeaders.builder().applyMutation(functionalGroupHeaders).build());
        }

        /**
         * <p>
         * The delimiters, for example semicolon (<code>;</code>), that separates sections of the headers for the X12
         * object.
         * </p>
         * 
         * @param delimiters
         *        The delimiters, for example semicolon (<code>;</code>), that separates sections of the headers for the
         *        X12 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiters(X12Delimiters delimiters);

        /**
         * <p>
         * The delimiters, for example semicolon (<code>;</code>), that separates sections of the headers for the X12
         * object.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12Delimiters.Builder} avoiding the need
         * to create one manually via {@link X12Delimiters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12Delimiters.Builder#build()} is called immediately and its
         * result is passed to {@link #delimiters(X12Delimiters)}.
         * 
         * @param delimiters
         *        a consumer that will call methods on {@link X12Delimiters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delimiters(X12Delimiters)
         */
        default Builder delimiters(Consumer<X12Delimiters.Builder> delimiters) {
            return delimiters(X12Delimiters.builder().applyMutation(delimiters).build());
        }

        /**
         * <p>
         * Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or <code>FALSE</code>.
         * </p>
         * 
         * @param validateEdi
         *        Specifies whether or not to validate the EDI for this X12 object: <code>TRUE</code> or
         *        <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateEdi(Boolean validateEdi);
    }

    static final class BuilderImpl implements Builder {
        private X12InterchangeControlHeaders interchangeControlHeaders;

        private X12FunctionalGroupHeaders functionalGroupHeaders;

        private X12Delimiters delimiters;

        private Boolean validateEdi;

        private BuilderImpl() {
        }

        private BuilderImpl(X12OutboundEdiHeaders model) {
            interchangeControlHeaders(model.interchangeControlHeaders);
            functionalGroupHeaders(model.functionalGroupHeaders);
            delimiters(model.delimiters);
            validateEdi(model.validateEdi);
        }

        public final X12InterchangeControlHeaders.Builder getInterchangeControlHeaders() {
            return interchangeControlHeaders != null ? interchangeControlHeaders.toBuilder() : null;
        }

        public final void setInterchangeControlHeaders(X12InterchangeControlHeaders.BuilderImpl interchangeControlHeaders) {
            this.interchangeControlHeaders = interchangeControlHeaders != null ? interchangeControlHeaders.build() : null;
        }

        @Override
        public final Builder interchangeControlHeaders(X12InterchangeControlHeaders interchangeControlHeaders) {
            this.interchangeControlHeaders = interchangeControlHeaders;
            return this;
        }

        public final X12FunctionalGroupHeaders.Builder getFunctionalGroupHeaders() {
            return functionalGroupHeaders != null ? functionalGroupHeaders.toBuilder() : null;
        }

        public final void setFunctionalGroupHeaders(X12FunctionalGroupHeaders.BuilderImpl functionalGroupHeaders) {
            this.functionalGroupHeaders = functionalGroupHeaders != null ? functionalGroupHeaders.build() : null;
        }

        @Override
        public final Builder functionalGroupHeaders(X12FunctionalGroupHeaders functionalGroupHeaders) {
            this.functionalGroupHeaders = functionalGroupHeaders;
            return this;
        }

        public final X12Delimiters.Builder getDelimiters() {
            return delimiters != null ? delimiters.toBuilder() : null;
        }

        public final void setDelimiters(X12Delimiters.BuilderImpl delimiters) {
            this.delimiters = delimiters != null ? delimiters.build() : null;
        }

        @Override
        public final Builder delimiters(X12Delimiters delimiters) {
            this.delimiters = delimiters;
            return this;
        }

        public final Boolean getValidateEdi() {
            return validateEdi;
        }

        public final void setValidateEdi(Boolean validateEdi) {
            this.validateEdi = validateEdi;
        }

        @Override
        public final Builder validateEdi(Boolean validateEdi) {
            this.validateEdi = validateEdi;
            return this;
        }

        @Override
        public X12OutboundEdiHeaders build() {
            return new X12OutboundEdiHeaders(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
