/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.CapabilityOptions;
import software.amazon.awssdk.services.b2bi.model.PartnershipCapabilitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePartnershipRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, UpdatePartnershipRequest> {
    private static final SdkField<String> PARTNERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnershipId").getter(UpdatePartnershipRequest.getter(UpdatePartnershipRequest::partnershipId)).setter(UpdatePartnershipRequest.setter(Builder::partnershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePartnershipRequest.getter(UpdatePartnershipRequest::name)).setter(UpdatePartnershipRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(UpdatePartnershipRequest.getter(UpdatePartnershipRequest::capabilities)).setter(UpdatePartnershipRequest.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CapabilityOptions> CAPABILITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capabilityOptions").getter(UpdatePartnershipRequest.getter(UpdatePartnershipRequest::capabilityOptions)).setter(UpdatePartnershipRequest.setter(Builder::capabilityOptions)).constructor(CapabilityOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNERSHIP_ID_FIELD, NAME_FIELD, CAPABILITIES_FIELD, CAPABILITY_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePartnershipRequest.memberNameToFieldInitializer();
    private final String partnershipId;
    private final String name;
    private final List<String> capabilities;
    private final CapabilityOptions capabilityOptions;

    private UpdatePartnershipRequest(BuilderImpl builder) {
        super(builder);
        this.partnershipId = builder.partnershipId;
        this.name = builder.name;
        this.capabilities = builder.capabilities;
        this.capabilityOptions = builder.capabilityOptions;
    }

    public final String partnershipId() {
        return this.partnershipId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final CapabilityOptions capabilityOptions() {
        return this.capabilityOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.partnershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnershipRequest)) {
            return false;
        }
        UpdatePartnershipRequest other = (UpdatePartnershipRequest)((Object)obj);
        return Objects.equals(this.partnershipId(), other.partnershipId()) && Objects.equals(this.name(), other.name()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.capabilityOptions(), other.capabilityOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePartnershipRequest").add("PartnershipId", (Object)this.partnershipId()).add("Name", (Object)this.name()).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("CapabilityOptions", (Object)this.capabilityOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "partnershipId": {
                return Optional.ofNullable(clazz.cast(this.partnershipId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "capabilityOptions": {
                return Optional.ofNullable(clazz.cast(this.capabilityOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("partnershipId", PARTNERSHIP_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("capabilityOptions", CAPABILITY_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnershipRequest, T> g) {
        return obj -> g.apply((UpdatePartnershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String partnershipId;
        private String name;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private CapabilityOptions capabilityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnershipRequest model) {
            super(model);
            this.partnershipId(model.partnershipId);
            this.name(model.name);
            this.capabilities(model.capabilities);
            this.capabilityOptions(model.capabilityOptions);
        }

        public final String getPartnershipId() {
            return this.partnershipId;
        }

        public final void setPartnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
        }

        @Override
        public final Builder partnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final CapabilityOptions.Builder getCapabilityOptions() {
            return this.capabilityOptions != null ? this.capabilityOptions.toBuilder() : null;
        }

        public final void setCapabilityOptions(CapabilityOptions.BuilderImpl capabilityOptions) {
            this.capabilityOptions = capabilityOptions != null ? capabilityOptions.build() : null;
        }

        @Override
        public final Builder capabilityOptions(CapabilityOptions capabilityOptions) {
            this.capabilityOptions = capabilityOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePartnershipRequest build() {
            return new UpdatePartnershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePartnershipRequest> {
        public Builder partnershipId(String var1);

        public Builder name(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilityOptions(CapabilityOptions var1);

        default public Builder capabilityOptions(Consumer<CapabilityOptions.Builder> capabilityOptions) {
            return this.capabilityOptions((CapabilityOptions)((CapabilityOptions.Builder)CapabilityOptions.builder().applyMutation(capabilityOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

