/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum X12Version {
    VERSION_4010("VERSION_4010"),
    VERSION_4030("VERSION_4030"),
    VERSION_4050("VERSION_4050"),
    VERSION_4060("VERSION_4060"),
    VERSION_5010("VERSION_5010"),
    VERSION_5010_HIPAA("VERSION_5010_HIPAA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, X12Version> VALUE_MAP;
    private final String value;

    private X12Version(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static X12Version fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<X12Version> knownValues() {
        EnumSet<X12Version> knownValues = EnumSet.allOf(X12Version.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(X12Version.class, X12Version::toString);
    }
}

