/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.waiters.B2BiAsyncWaiter;
import software.amazon.awssdk.services.b2bi.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultB2BiAsyncWaiter
implements B2BiAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final B2BiAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetTransformerJobResponse> transformerJobSucceededWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultB2BiAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (B2BiAsyncClient)B2BiAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.transformerJobSucceededWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetTransformerJobResponse.class).acceptors(DefaultB2BiAsyncWaiter.transformerJobSucceededWaiterAcceptors())).overrideConfiguration(DefaultB2BiAsyncWaiter.transformerJobSucceededWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest) {
        return this.transformerJobSucceededWaiter.runAsync(() -> this.client.getTransformerJob(this.applyWaitersUserAgent(getTransformerJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetTransformerJobResponse>> waitUntilTransformerJobSucceeded(GetTransformerJobRequest getTransformerJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.transformerJobSucceededWaiter.runAsync(() -> this.client.getTransformerJob(this.applyWaitersUserAgent(getTransformerJobRequest)), DefaultB2BiAsyncWaiter.transformerJobSucceededWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetTransformerJobResponse>> transformerJobSucceededWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetTransformerJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetTransformerJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "succeeded");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration transformerJobSucceededWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(12);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static B2BiAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends B2BiRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((B2BiRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements B2BiAsyncWaiter.Builder {
        private B2BiAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public B2BiAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public B2BiAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public B2BiAsyncWaiter.Builder client(B2BiAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public B2BiAsyncWaiter build() {
            return new DefaultB2BiAsyncWaiter(this);
        }
    }
}

