/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.ParsedSplitFileContentsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestParsingResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, TestParsingResponse> {
    private static final SdkField<String> PARSED_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parsedFileContent").getter(TestParsingResponse.getter(TestParsingResponse::parsedFileContent)).setter(TestParsingResponse.setter(Builder::parsedFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedFileContent").build()}).build();
    private static final SdkField<List<String>> PARSED_SPLIT_FILE_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parsedSplitFileContents").getter(TestParsingResponse.getter(TestParsingResponse::parsedSplitFileContents)).setter(TestParsingResponse.setter(Builder::parsedSplitFileContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsedSplitFileContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARSED_FILE_CONTENT_FIELD, PARSED_SPLIT_FILE_CONTENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestParsingResponse.memberNameToFieldInitializer();
    private final String parsedFileContent;
    private final List<String> parsedSplitFileContents;

    private TestParsingResponse(BuilderImpl builder) {
        super(builder);
        this.parsedFileContent = builder.parsedFileContent;
        this.parsedSplitFileContents = builder.parsedSplitFileContents;
    }

    public final String parsedFileContent() {
        return this.parsedFileContent;
    }

    public final boolean hasParsedSplitFileContents() {
        return this.parsedSplitFileContents != null && !(this.parsedSplitFileContents instanceof SdkAutoConstructList);
    }

    public final List<String> parsedSplitFileContents() {
        return this.parsedSplitFileContents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parsedFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParsedSplitFileContents() ? this.parsedSplitFileContents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestParsingResponse)) {
            return false;
        }
        TestParsingResponse other = (TestParsingResponse)((Object)obj);
        return Objects.equals(this.parsedFileContent(), other.parsedFileContent()) && this.hasParsedSplitFileContents() == other.hasParsedSplitFileContents() && Objects.equals(this.parsedSplitFileContents(), other.parsedSplitFileContents());
    }

    public final String toString() {
        return ToString.builder((String)"TestParsingResponse").add("ParsedFileContent", (Object)this.parsedFileContent()).add("ParsedSplitFileContents", this.hasParsedSplitFileContents() ? this.parsedSplitFileContents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "parsedFileContent": {
                return Optional.ofNullable(clazz.cast(this.parsedFileContent()));
            }
            case "parsedSplitFileContents": {
                return Optional.ofNullable(clazz.cast(this.parsedSplitFileContents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parsedFileContent", PARSED_FILE_CONTENT_FIELD);
        map.put("parsedSplitFileContents", PARSED_SPLIT_FILE_CONTENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestParsingResponse, T> g) {
        return obj -> g.apply((TestParsingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String parsedFileContent;
        private List<String> parsedSplitFileContents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestParsingResponse model) {
            super(model);
            this.parsedFileContent(model.parsedFileContent);
            this.parsedSplitFileContents(model.parsedSplitFileContents);
        }

        public final String getParsedFileContent() {
            return this.parsedFileContent;
        }

        public final void setParsedFileContent(String parsedFileContent) {
            this.parsedFileContent = parsedFileContent;
        }

        @Override
        public final Builder parsedFileContent(String parsedFileContent) {
            this.parsedFileContent = parsedFileContent;
            return this;
        }

        public final Collection<String> getParsedSplitFileContents() {
            if (this.parsedSplitFileContents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parsedSplitFileContents;
        }

        public final void setParsedSplitFileContents(Collection<String> parsedSplitFileContents) {
            this.parsedSplitFileContents = ParsedSplitFileContentsListCopier.copy(parsedSplitFileContents);
        }

        @Override
        public final Builder parsedSplitFileContents(Collection<String> parsedSplitFileContents) {
            this.parsedSplitFileContents = ParsedSplitFileContentsListCopier.copy(parsedSplitFileContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parsedSplitFileContents(String ... parsedSplitFileContents) {
            this.parsedSplitFileContents(Arrays.asList(parsedSplitFileContents));
            return this;
        }

        @Override
        public TestParsingResponse build() {
            return new TestParsingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestParsingResponse> {
        public Builder parsedFileContent(String var1);

        public Builder parsedSplitFileContents(Collection<String> var1);

        public Builder parsedSplitFileContents(String ... var1);
    }
}

