/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum X12SplitBy {
    NONE("NONE"),
    TRANSACTION("TRANSACTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, X12SplitBy> VALUE_MAP;
    private final String value;

    private X12SplitBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static X12SplitBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<X12SplitBy> knownValues() {
        EnumSet<X12SplitBy> knownValues = EnumSet.allOf(X12SplitBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(X12SplitBy.class, X12SplitBy::toString);
    }
}

