/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.ConversionTargetFormat;
import software.amazon.awssdk.services.b2bi.model.ConversionTargetFormatDetails;
import software.amazon.awssdk.services.b2bi.model.OutputSampleFileSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversionTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversionTarget> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(ConversionTarget.getter(ConversionTarget::fileFormatAsString)).setter(ConversionTarget.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<ConversionTargetFormatDetails> FORMAT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatDetails").getter(ConversionTarget.getter(ConversionTarget::formatDetails)).setter(ConversionTarget.setter(Builder::formatDetails)).constructor(ConversionTargetFormatDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatDetails").build()}).build();
    private static final SdkField<OutputSampleFileSource> OUTPUT_SAMPLE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputSampleFile").getter(ConversionTarget.getter(ConversionTarget::outputSampleFile)).setter(ConversionTarget.setter(Builder::outputSampleFile)).constructor(OutputSampleFileSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSampleFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD, FORMAT_DETAILS_FIELD, OUTPUT_SAMPLE_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConversionTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileFormat;
    private final ConversionTargetFormatDetails formatDetails;
    private final OutputSampleFileSource outputSampleFile;

    private ConversionTarget(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.formatDetails = builder.formatDetails;
        this.outputSampleFile = builder.outputSampleFile;
    }

    public final ConversionTargetFormat fileFormat() {
        return ConversionTargetFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final ConversionTargetFormatDetails formatDetails() {
        return this.formatDetails;
    }

    public final OutputSampleFileSource outputSampleFile() {
        return this.outputSampleFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSampleFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTarget)) {
            return false;
        }
        ConversionTarget other = (ConversionTarget)obj;
        return Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.formatDetails(), other.formatDetails()) && Objects.equals(this.outputSampleFile(), other.outputSampleFile());
    }

    public final String toString() {
        return ToString.builder((String)"ConversionTarget").add("FileFormat", (Object)this.fileFormatAsString()).add("FormatDetails", (Object)this.formatDetails()).add("OutputSampleFile", (Object)this.outputSampleFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "formatDetails": {
                return Optional.ofNullable(clazz.cast(this.formatDetails()));
            }
            case "outputSampleFile": {
                return Optional.ofNullable(clazz.cast(this.outputSampleFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("formatDetails", FORMAT_DETAILS_FIELD);
        map.put("outputSampleFile", OUTPUT_SAMPLE_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversionTarget, T> g) {
        return obj -> g.apply((ConversionTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileFormat;
        private ConversionTargetFormatDetails formatDetails;
        private OutputSampleFileSource outputSampleFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionTarget model) {
            this.fileFormat(model.fileFormat);
            this.formatDetails(model.formatDetails);
            this.outputSampleFile(model.outputSampleFile);
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ConversionTargetFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final ConversionTargetFormatDetails.Builder getFormatDetails() {
            return this.formatDetails != null ? this.formatDetails.toBuilder() : null;
        }

        public final void setFormatDetails(ConversionTargetFormatDetails.BuilderImpl formatDetails) {
            this.formatDetails = formatDetails != null ? formatDetails.build() : null;
        }

        @Override
        public final Builder formatDetails(ConversionTargetFormatDetails formatDetails) {
            this.formatDetails = formatDetails;
            return this;
        }

        public final OutputSampleFileSource.Builder getOutputSampleFile() {
            return this.outputSampleFile != null ? this.outputSampleFile.toBuilder() : null;
        }

        public final void setOutputSampleFile(OutputSampleFileSource.BuilderImpl outputSampleFile) {
            this.outputSampleFile = outputSampleFile != null ? outputSampleFile.build() : null;
        }

        @Override
        public final Builder outputSampleFile(OutputSampleFileSource outputSampleFile) {
            this.outputSampleFile = outputSampleFile;
            return this;
        }

        public ConversionTarget build() {
            return new ConversionTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversionTarget> {
        public Builder fileFormat(String var1);

        public Builder fileFormat(ConversionTargetFormat var1);

        public Builder formatDetails(ConversionTargetFormatDetails var1);

        default public Builder formatDetails(Consumer<ConversionTargetFormatDetails.Builder> formatDetails) {
            return this.formatDetails((ConversionTargetFormatDetails)((ConversionTargetFormatDetails.Builder)ConversionTargetFormatDetails.builder().applyMutation(formatDetails)).build());
        }

        public Builder outputSampleFile(OutputSampleFileSource var1);

        default public Builder outputSampleFile(Consumer<OutputSampleFileSource.Builder> outputSampleFile) {
            return this.outputSampleFile((OutputSampleFileSource)((OutputSampleFileSource.Builder)OutputSampleFileSource.builder().applyMutation(outputSampleFile)).build());
        }
    }
}

