/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains options for wrapping (line folding) in X12 EDI files. Wrapping controls how long lines are handled in the
 * EDI output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WrapOptions implements SdkPojo, Serializable, ToCopyableBuilder<WrapOptions.Builder, WrapOptions> {
    private static final SdkField<String> WRAP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("wrapBy")
            .getter(getter(WrapOptions::wrapByAsString)).setter(setter(Builder::wrapBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wrapBy").build()).build();

    private static final SdkField<String> LINE_TERMINATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lineTerminator").getter(getter(WrapOptions::lineTerminatorAsString))
            .setter(setter(Builder::lineTerminator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineTerminator").build()).build();

    private static final SdkField<Integer> LINE_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("lineLength").getter(getter(WrapOptions::lineLength)).setter(setter(Builder::lineLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WRAP_BY_FIELD,
            LINE_TERMINATOR_FIELD, LINE_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String wrapBy;

    private final String lineTerminator;

    private final Integer lineLength;

    private WrapOptions(BuilderImpl builder) {
        this.wrapBy = builder.wrapBy;
        this.lineTerminator = builder.lineTerminator;
        this.lineLength = builder.lineLength;
    }

    /**
     * <p>
     * Specifies the method used for wrapping lines in the EDI output. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SEGMENT</code>: Wraps by segment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
     * </p>
     * <note>
     * <p>
     * When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator value.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrapBy} will
     * return {@link WrapFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wrapByAsString}.
     * </p>
     * 
     * @return Specifies the method used for wrapping lines in the EDI output. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SEGMENT</code>: Wraps by segment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
     *         </p>
     *         <note>
     *         <p>
     *         When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator
     *         value.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
     *         </p>
     *         </li>
     * @see WrapFormat
     */
    public final WrapFormat wrapBy() {
        return WrapFormat.fromValue(wrapBy);
    }

    /**
     * <p>
     * Specifies the method used for wrapping lines in the EDI output. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SEGMENT</code>: Wraps by segment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
     * </p>
     * <note>
     * <p>
     * When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator value.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrapBy} will
     * return {@link WrapFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wrapByAsString}.
     * </p>
     * 
     * @return Specifies the method used for wrapping lines in the EDI output. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SEGMENT</code>: Wraps by segment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
     *         </p>
     *         <note>
     *         <p>
     *         When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator
     *         value.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
     *         </p>
     *         </li>
     * @see WrapFormat
     */
    public final String wrapByAsString() {
        return wrapBy;
    }

    /**
     * <p>
     * Specifies the character sequence used to terminate lines when wrapping. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRLF</code>: carriage return and line feed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LF</code>: line feed)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CR</code>: carriage return
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineTerminator}
     * will return {@link LineTerminator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lineTerminatorAsString}.
     * </p>
     * 
     * @return Specifies the character sequence used to terminate lines when wrapping. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRLF</code>: carriage return and line feed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LF</code>: line feed)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CR</code>: carriage return
     *         </p>
     *         </li>
     * @see LineTerminator
     */
    public final LineTerminator lineTerminator() {
        return LineTerminator.fromValue(lineTerminator);
    }

    /**
     * <p>
     * Specifies the character sequence used to terminate lines when wrapping. Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CRLF</code>: carriage return and line feed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LF</code>: line feed)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CR</code>: carriage return
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lineTerminator}
     * will return {@link LineTerminator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lineTerminatorAsString}.
     * </p>
     * 
     * @return Specifies the character sequence used to terminate lines when wrapping. Valid values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CRLF</code>: carriage return and line feed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LF</code>: line feed)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CR</code>: carriage return
     *         </p>
     *         </li>
     * @see LineTerminator
     */
    public final String lineTerminatorAsString() {
        return lineTerminator;
    }

    /**
     * <p>
     * Specifies the maximum length of a line before wrapping occurs. This value is used when <code>wrapBy</code> is set
     * to <code>LINE_LENGTH</code>.
     * </p>
     * 
     * @return Specifies the maximum length of a line before wrapping occurs. This value is used when
     *         <code>wrapBy</code> is set to <code>LINE_LENGTH</code>.
     */
    public final Integer lineLength() {
        return lineLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wrapByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lineTerminatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lineLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WrapOptions)) {
            return false;
        }
        WrapOptions other = (WrapOptions) obj;
        return Objects.equals(wrapByAsString(), other.wrapByAsString())
                && Objects.equals(lineTerminatorAsString(), other.lineTerminatorAsString())
                && Objects.equals(lineLength(), other.lineLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WrapOptions").add("WrapBy", wrapByAsString()).add("LineTerminator", lineTerminatorAsString())
                .add("LineLength", lineLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "wrapBy":
            return Optional.ofNullable(clazz.cast(wrapByAsString()));
        case "lineTerminator":
            return Optional.ofNullable(clazz.cast(lineTerminatorAsString()));
        case "lineLength":
            return Optional.ofNullable(clazz.cast(lineLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("wrapBy", WRAP_BY_FIELD);
        map.put("lineTerminator", LINE_TERMINATOR_FIELD);
        map.put("lineLength", LINE_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WrapOptions, T> g) {
        return obj -> g.apply((WrapOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WrapOptions> {
        /**
         * <p>
         * Specifies the method used for wrapping lines in the EDI output. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SEGMENT</code>: Wraps by segment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
         * </p>
         * <note>
         * <p>
         * When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator value.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param wrapBy
         *        Specifies the method used for wrapping lines in the EDI output. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SEGMENT</code>: Wraps by segment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
         *        </p>
         *        <note>
         *        <p>
         *        When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator
         *        value.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
         *        </p>
         *        </li>
         * @see WrapFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrapFormat
         */
        Builder wrapBy(String wrapBy);

        /**
         * <p>
         * Specifies the method used for wrapping lines in the EDI output. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SEGMENT</code>: Wraps by segment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
         * </p>
         * <note>
         * <p>
         * When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator value.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param wrapBy
         *        Specifies the method used for wrapping lines in the EDI output. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SEGMENT</code>: Wraps by segment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_LINE</code>: Indicates that the entire content is on a single line.
         *        </p>
         *        <note>
         *        <p>
         *        When you specify <code>ONE_LINE</code>, do not provide either the line length nor the line terminator
         *        value.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>LINE_LENGTH</code>: Wraps by character count, as specified by <code>lineLength</code> value.
         *        </p>
         *        </li>
         * @see WrapFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrapFormat
         */
        Builder wrapBy(WrapFormat wrapBy);

        /**
         * <p>
         * Specifies the character sequence used to terminate lines when wrapping. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRLF</code>: carriage return and line feed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LF</code>: line feed)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CR</code>: carriage return
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineTerminator
         *        Specifies the character sequence used to terminate lines when wrapping. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRLF</code>: carriage return and line feed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LF</code>: line feed)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CR</code>: carriage return
         *        </p>
         *        </li>
         * @see LineTerminator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineTerminator
         */
        Builder lineTerminator(String lineTerminator);

        /**
         * <p>
         * Specifies the character sequence used to terminate lines when wrapping. Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CRLF</code>: carriage return and line feed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LF</code>: line feed)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CR</code>: carriage return
         * </p>
         * </li>
         * </ul>
         * 
         * @param lineTerminator
         *        Specifies the character sequence used to terminate lines when wrapping. Valid values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CRLF</code>: carriage return and line feed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LF</code>: line feed)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CR</code>: carriage return
         *        </p>
         *        </li>
         * @see LineTerminator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineTerminator
         */
        Builder lineTerminator(LineTerminator lineTerminator);

        /**
         * <p>
         * Specifies the maximum length of a line before wrapping occurs. This value is used when <code>wrapBy</code> is
         * set to <code>LINE_LENGTH</code>.
         * </p>
         * 
         * @param lineLength
         *        Specifies the maximum length of a line before wrapping occurs. This value is used when
         *        <code>wrapBy</code> is set to <code>LINE_LENGTH</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineLength(Integer lineLength);
    }

    static final class BuilderImpl implements Builder {
        private String wrapBy;

        private String lineTerminator;

        private Integer lineLength;

        private BuilderImpl() {
        }

        private BuilderImpl(WrapOptions model) {
            wrapBy(model.wrapBy);
            lineTerminator(model.lineTerminator);
            lineLength(model.lineLength);
        }

        public final String getWrapBy() {
            return wrapBy;
        }

        public final void setWrapBy(String wrapBy) {
            this.wrapBy = wrapBy;
        }

        @Override
        public final Builder wrapBy(String wrapBy) {
            this.wrapBy = wrapBy;
            return this;
        }

        @Override
        public final Builder wrapBy(WrapFormat wrapBy) {
            this.wrapBy(wrapBy == null ? null : wrapBy.toString());
            return this;
        }

        public final String getLineTerminator() {
            return lineTerminator;
        }

        public final void setLineTerminator(String lineTerminator) {
            this.lineTerminator = lineTerminator;
        }

        @Override
        public final Builder lineTerminator(String lineTerminator) {
            this.lineTerminator = lineTerminator;
            return this;
        }

        @Override
        public final Builder lineTerminator(LineTerminator lineTerminator) {
            this.lineTerminator(lineTerminator == null ? null : lineTerminator.toString());
            return this;
        }

        public final Integer getLineLength() {
            return lineLength;
        }

        public final void setLineLength(Integer lineLength) {
            this.lineLength = lineLength;
        }

        @Override
        public final Builder lineLength(Integer lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        @Override
        public WrapOptions build() {
            return new WrapOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
