/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.b2bi.model.X12CodeListValidationRule;
import software.amazon.awssdk.services.b2bi.model.X12ElementLengthValidationRule;
import software.amazon.awssdk.services.b2bi.model.X12ElementRequirementValidationRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12ValidationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12ValidationRule> {
    private static final SdkField<X12CodeListValidationRule> CODE_LIST_VALIDATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeListValidationRule").getter(X12ValidationRule.getter(X12ValidationRule::codeListValidationRule)).setter(X12ValidationRule.setter(Builder::codeListValidationRule)).constructor(X12CodeListValidationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeListValidationRule").build()}).build();
    private static final SdkField<X12ElementLengthValidationRule> ELEMENT_LENGTH_VALIDATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elementLengthValidationRule").getter(X12ValidationRule.getter(X12ValidationRule::elementLengthValidationRule)).setter(X12ValidationRule.setter(Builder::elementLengthValidationRule)).constructor(X12ElementLengthValidationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementLengthValidationRule").build()}).build();
    private static final SdkField<X12ElementRequirementValidationRule> ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("elementRequirementValidationRule").getter(X12ValidationRule.getter(X12ValidationRule::elementRequirementValidationRule)).setter(X12ValidationRule.setter(Builder::elementRequirementValidationRule)).constructor(X12ElementRequirementValidationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementRequirementValidationRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_LIST_VALIDATION_RULE_FIELD, ELEMENT_LENGTH_VALIDATION_RULE_FIELD, ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12ValidationRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final X12CodeListValidationRule codeListValidationRule;
    private final X12ElementLengthValidationRule elementLengthValidationRule;
    private final X12ElementRequirementValidationRule elementRequirementValidationRule;
    private final Type type;

    private X12ValidationRule(BuilderImpl builder) {
        this.codeListValidationRule = builder.codeListValidationRule;
        this.elementLengthValidationRule = builder.elementLengthValidationRule;
        this.elementRequirementValidationRule = builder.elementRequirementValidationRule;
        this.type = builder.type;
    }

    public final X12CodeListValidationRule codeListValidationRule() {
        return this.codeListValidationRule;
    }

    public final X12ElementLengthValidationRule elementLengthValidationRule() {
        return this.elementLengthValidationRule;
    }

    public final X12ElementRequirementValidationRule elementRequirementValidationRule() {
        return this.elementRequirementValidationRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeListValidationRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.elementLengthValidationRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.elementRequirementValidationRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ValidationRule)) {
            return false;
        }
        X12ValidationRule other = (X12ValidationRule)obj;
        return Objects.equals(this.codeListValidationRule(), other.codeListValidationRule()) && Objects.equals(this.elementLengthValidationRule(), other.elementLengthValidationRule()) && Objects.equals(this.elementRequirementValidationRule(), other.elementRequirementValidationRule());
    }

    public final String toString() {
        return ToString.builder((String)"X12ValidationRule").add("CodeListValidationRule", (Object)this.codeListValidationRule()).add("ElementLengthValidationRule", (Object)this.elementLengthValidationRule()).add("ElementRequirementValidationRule", (Object)this.elementRequirementValidationRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeListValidationRule": {
                return Optional.ofNullable(clazz.cast(this.codeListValidationRule()));
            }
            case "elementLengthValidationRule": {
                return Optional.ofNullable(clazz.cast(this.elementLengthValidationRule()));
            }
            case "elementRequirementValidationRule": {
                return Optional.ofNullable(clazz.cast(this.elementRequirementValidationRule()));
            }
        }
        return Optional.empty();
    }

    public static X12ValidationRule fromCodeListValidationRule(X12CodeListValidationRule codeListValidationRule) {
        return (X12ValidationRule)X12ValidationRule.builder().codeListValidationRule(codeListValidationRule).build();
    }

    public static X12ValidationRule fromCodeListValidationRule(Consumer<X12CodeListValidationRule.Builder> codeListValidationRule) {
        X12CodeListValidationRule.Builder builder = X12CodeListValidationRule.builder();
        codeListValidationRule.accept(builder);
        return X12ValidationRule.fromCodeListValidationRule((X12CodeListValidationRule)builder.build());
    }

    public static X12ValidationRule fromElementLengthValidationRule(X12ElementLengthValidationRule elementLengthValidationRule) {
        return (X12ValidationRule)X12ValidationRule.builder().elementLengthValidationRule(elementLengthValidationRule).build();
    }

    public static X12ValidationRule fromElementLengthValidationRule(Consumer<X12ElementLengthValidationRule.Builder> elementLengthValidationRule) {
        X12ElementLengthValidationRule.Builder builder = X12ElementLengthValidationRule.builder();
        elementLengthValidationRule.accept(builder);
        return X12ValidationRule.fromElementLengthValidationRule((X12ElementLengthValidationRule)builder.build());
    }

    public static X12ValidationRule fromElementRequirementValidationRule(X12ElementRequirementValidationRule elementRequirementValidationRule) {
        return (X12ValidationRule)X12ValidationRule.builder().elementRequirementValidationRule(elementRequirementValidationRule).build();
    }

    public static X12ValidationRule fromElementRequirementValidationRule(Consumer<X12ElementRequirementValidationRule.Builder> elementRequirementValidationRule) {
        X12ElementRequirementValidationRule.Builder builder = X12ElementRequirementValidationRule.builder();
        elementRequirementValidationRule.accept(builder);
        return X12ValidationRule.fromElementRequirementValidationRule((X12ElementRequirementValidationRule)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeListValidationRule", CODE_LIST_VALIDATION_RULE_FIELD);
        map.put("elementLengthValidationRule", ELEMENT_LENGTH_VALIDATION_RULE_FIELD);
        map.put("elementRequirementValidationRule", ELEMENT_REQUIREMENT_VALIDATION_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ValidationRule, T> g) {
        return obj -> g.apply((X12ValidationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CODE_LIST_VALIDATION_RULE,
        ELEMENT_LENGTH_VALIDATION_RULE,
        ELEMENT_REQUIREMENT_VALIDATION_RULE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private X12CodeListValidationRule codeListValidationRule;
        private X12ElementLengthValidationRule elementLengthValidationRule;
        private X12ElementRequirementValidationRule elementRequirementValidationRule;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(X12ValidationRule model) {
            this.codeListValidationRule(model.codeListValidationRule);
            this.elementLengthValidationRule(model.elementLengthValidationRule);
            this.elementRequirementValidationRule(model.elementRequirementValidationRule);
        }

        public final X12CodeListValidationRule.Builder getCodeListValidationRule() {
            return this.codeListValidationRule != null ? this.codeListValidationRule.toBuilder() : null;
        }

        public final void setCodeListValidationRule(X12CodeListValidationRule.BuilderImpl codeListValidationRule) {
            X12CodeListValidationRule oldValue = this.codeListValidationRule;
            this.codeListValidationRule = codeListValidationRule != null ? codeListValidationRule.build() : null;
            this.handleUnionValueChange(Type.CODE_LIST_VALIDATION_RULE, oldValue, this.codeListValidationRule);
        }

        @Override
        public final Builder codeListValidationRule(X12CodeListValidationRule codeListValidationRule) {
            X12CodeListValidationRule oldValue = this.codeListValidationRule;
            this.codeListValidationRule = codeListValidationRule;
            this.handleUnionValueChange(Type.CODE_LIST_VALIDATION_RULE, oldValue, this.codeListValidationRule);
            return this;
        }

        public final X12ElementLengthValidationRule.Builder getElementLengthValidationRule() {
            return this.elementLengthValidationRule != null ? this.elementLengthValidationRule.toBuilder() : null;
        }

        public final void setElementLengthValidationRule(X12ElementLengthValidationRule.BuilderImpl elementLengthValidationRule) {
            X12ElementLengthValidationRule oldValue = this.elementLengthValidationRule;
            this.elementLengthValidationRule = elementLengthValidationRule != null ? elementLengthValidationRule.build() : null;
            this.handleUnionValueChange(Type.ELEMENT_LENGTH_VALIDATION_RULE, oldValue, this.elementLengthValidationRule);
        }

        @Override
        public final Builder elementLengthValidationRule(X12ElementLengthValidationRule elementLengthValidationRule) {
            X12ElementLengthValidationRule oldValue = this.elementLengthValidationRule;
            this.elementLengthValidationRule = elementLengthValidationRule;
            this.handleUnionValueChange(Type.ELEMENT_LENGTH_VALIDATION_RULE, oldValue, this.elementLengthValidationRule);
            return this;
        }

        public final X12ElementRequirementValidationRule.Builder getElementRequirementValidationRule() {
            return this.elementRequirementValidationRule != null ? this.elementRequirementValidationRule.toBuilder() : null;
        }

        public final void setElementRequirementValidationRule(X12ElementRequirementValidationRule.BuilderImpl elementRequirementValidationRule) {
            X12ElementRequirementValidationRule oldValue = this.elementRequirementValidationRule;
            this.elementRequirementValidationRule = elementRequirementValidationRule != null ? elementRequirementValidationRule.build() : null;
            this.handleUnionValueChange(Type.ELEMENT_REQUIREMENT_VALIDATION_RULE, oldValue, this.elementRequirementValidationRule);
        }

        @Override
        public final Builder elementRequirementValidationRule(X12ElementRequirementValidationRule elementRequirementValidationRule) {
            X12ElementRequirementValidationRule oldValue = this.elementRequirementValidationRule;
            this.elementRequirementValidationRule = elementRequirementValidationRule;
            this.handleUnionValueChange(Type.ELEMENT_REQUIREMENT_VALIDATION_RULE, oldValue, this.elementRequirementValidationRule);
            return this;
        }

        public X12ValidationRule build() {
            return new X12ValidationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12ValidationRule> {
        public Builder codeListValidationRule(X12CodeListValidationRule var1);

        default public Builder codeListValidationRule(Consumer<X12CodeListValidationRule.Builder> codeListValidationRule) {
            return this.codeListValidationRule((X12CodeListValidationRule)((X12CodeListValidationRule.Builder)X12CodeListValidationRule.builder().applyMutation(codeListValidationRule)).build());
        }

        public Builder elementLengthValidationRule(X12ElementLengthValidationRule var1);

        default public Builder elementLengthValidationRule(Consumer<X12ElementLengthValidationRule.Builder> elementLengthValidationRule) {
            return this.elementLengthValidationRule((X12ElementLengthValidationRule)((X12ElementLengthValidationRule.Builder)X12ElementLengthValidationRule.builder().applyMutation(elementLengthValidationRule)).build());
        }

        public Builder elementRequirementValidationRule(X12ElementRequirementValidationRule var1);

        default public Builder elementRequirementValidationRule(Consumer<X12ElementRequirementValidationRule.Builder> elementRequirementValidationRule) {
            return this.elementRequirementValidationRule((X12ElementRequirementValidationRule)((X12ElementRequirementValidationRule.Builder)X12ElementRequirementValidationRule.builder().applyMutation(elementRequirementValidationRule)).build());
        }
    }
}

