/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains advanced options for EDI processing. Currently, only X12 advanced options are supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedOptions implements SdkPojo, Serializable, ToCopyableBuilder<AdvancedOptions.Builder, AdvancedOptions> {
    private static final SdkField<X12AdvancedOptions> X12_FIELD = SdkField.<X12AdvancedOptions> builder(MarshallingType.SDK_POJO)
            .memberName("x12").getter(getter(AdvancedOptions::x12)).setter(setter(Builder::x12))
            .constructor(X12AdvancedOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12AdvancedOptions x12;

    private AdvancedOptions(BuilderImpl builder) {
        this.x12 = builder.x12;
    }

    /**
     * <p>
     * A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
     * </p>
     * 
     * @return A structure that contains X12-specific advanced options, such as split options for processing X12 EDI
     *         files.
     */
    public final X12AdvancedOptions x12() {
        return x12;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x12());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedOptions)) {
            return false;
        }
        AdvancedOptions other = (AdvancedOptions) obj;
        return Objects.equals(x12(), other.x12());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedOptions").add("X12", x12()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "x12":
            return Optional.ofNullable(clazz.cast(x12()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x12", X12_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedOptions, T> g) {
        return obj -> g.apply((AdvancedOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedOptions> {
        /**
         * <p>
         * A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
         * </p>
         * 
         * @param x12
         *        A structure that contains X12-specific advanced options, such as split options for processing X12 EDI
         *        files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x12(X12AdvancedOptions x12);

        /**
         * <p>
         * A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12AdvancedOptions.Builder} avoiding the
         * need to create one manually via {@link X12AdvancedOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12AdvancedOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #x12(X12AdvancedOptions)}.
         * 
         * @param x12
         *        a consumer that will call methods on {@link X12AdvancedOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #x12(X12AdvancedOptions)
         */
        default Builder x12(Consumer<X12AdvancedOptions.Builder> x12) {
            return x12(X12AdvancedOptions.builder().applyMutation(x12).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12AdvancedOptions x12;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedOptions model) {
            x12(model.x12);
        }

        public final X12AdvancedOptions.Builder getX12() {
            return x12 != null ? x12.toBuilder() : null;
        }

        public final void setX12(X12AdvancedOptions.BuilderImpl x12) {
            this.x12 = x12 != null ? x12.build() : null;
        }

        @Override
        public final Builder x12(X12AdvancedOptions x12) {
            this.x12 = x12;
            return this;
        }

        @Override
        public AdvancedOptions build() {
            return new AdvancedOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
