/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePartnershipRequest extends B2BiRequest implements
        ToCopyableBuilder<CreatePartnershipRequest.Builder, CreatePartnershipRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(CreatePartnershipRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreatePartnershipRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(CreatePartnershipRequest::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phone")
            .getter(getter(CreatePartnershipRequest::phone)).setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CreatePartnershipRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapabilityOptions> CAPABILITY_OPTIONS_FIELD = SdkField
            .<CapabilityOptions> builder(MarshallingType.SDK_POJO).memberName("capabilityOptions")
            .getter(getter(CreatePartnershipRequest::capabilityOptions)).setter(setter(Builder::capabilityOptions))
            .constructor(CapabilityOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityOptions").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePartnershipRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreatePartnershipRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, NAME_FIELD,
            EMAIL_FIELD, PHONE_FIELD, CAPABILITIES_FIELD, CAPABILITY_OPTIONS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileId;

    private final String name;

    private final String email;

    private final String phone;

    private final List<String> capabilities;

    private final CapabilityOptions capabilityOptions;

    private final String clientToken;

    private final List<Tag> tags;

    private CreatePartnershipRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.capabilities = builder.capabilities;
        this.capabilityOptions = builder.capabilityOptions;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the unique, system-generated identifier for the profile connected to this partnership.
     * </p>
     * 
     * @return Specifies the unique, system-generated identifier for the profile connected to this partnership.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Specifies a descriptive name for the partnership.
     * </p>
     * 
     * @return Specifies a descriptive name for the partnership.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the email address associated with this trading partner.
     * </p>
     * 
     * @return Specifies the email address associated with this trading partner.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Specifies the phone number associated with the partnership.
     * </p>
     * 
     * @return Specifies the phone number associated with the partnership.
     */
    public final String phone() {
        return phone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of the capabilities associated with this partnership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Specifies a list of the capabilities associated with this partnership.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * Specify the structure that contains the details for the associated capabilities.
     * </p>
     * 
     * @return Specify the structure that contains the details for the associated capabilities.
     */
    public final CapabilityOptions capabilityOptions() {
        return capabilityOptions;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You
     * can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
     *         type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(phone());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartnershipRequest)) {
            return false;
        }
        CreatePartnershipRequest other = (CreatePartnershipRequest) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email()) && Objects.equals(phone(), other.phone())
                && hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(capabilityOptions(), other.capabilityOptions())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePartnershipRequest").add("ProfileId", profileId()).add("Name", name())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Phone", phone() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", hasCapabilities() ? capabilities() : null).add("CapabilityOptions", capabilityOptions())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "phone":
            return Optional.ofNullable(clazz.cast(phone()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "capabilityOptions":
            return Optional.ofNullable(clazz.cast(capabilityOptions()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("phone", PHONE_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("capabilityOptions", CAPABILITY_OPTIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePartnershipRequest, T> g) {
        return obj -> g.apply((CreatePartnershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePartnershipRequest> {
        /**
         * <p>
         * Specifies the unique, system-generated identifier for the profile connected to this partnership.
         * </p>
         * 
         * @param profileId
         *        Specifies the unique, system-generated identifier for the profile connected to this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Specifies a descriptive name for the partnership.
         * </p>
         * 
         * @param name
         *        Specifies a descriptive name for the partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the email address associated with this trading partner.
         * </p>
         * 
         * @param email
         *        Specifies the email address associated with this trading partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Specifies the phone number associated with the partnership.
         * </p>
         * 
         * @param phone
         *        Specifies the phone number associated with the partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(String phone);

        /**
         * <p>
         * Specifies a list of the capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Specifies a list of the capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * Specifies a list of the capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Specifies a list of the capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * Specify the structure that contains the details for the associated capabilities.
         * </p>
         * 
         * @param capabilityOptions
         *        Specify the structure that contains the details for the associated capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityOptions(CapabilityOptions capabilityOptions);

        /**
         * <p>
         * Specify the structure that contains the details for the associated capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityOptions.Builder} avoiding the
         * need to create one manually via {@link CapabilityOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilityOptions(CapabilityOptions)}.
         * 
         * @param capabilityOptions
         *        a consumer that will call methods on {@link CapabilityOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityOptions(CapabilityOptions)
         */
        default Builder capabilityOptions(Consumer<CapabilityOptions.Builder> capabilityOptions) {
            return capabilityOptions(CapabilityOptions.builder().applyMutation(capabilityOptions).build());
        }

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param clientToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.b2bi.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String profileId;

        private String name;

        private String email;

        private String phone;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private CapabilityOptions capabilityOptions;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartnershipRequest model) {
            super(model);
            profileId(model.profileId);
            name(model.name);
            email(model.email);
            phone(model.phone);
            capabilities(model.capabilities);
            capabilityOptions(model.capabilityOptions);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final CapabilityOptions.Builder getCapabilityOptions() {
            return capabilityOptions != null ? capabilityOptions.toBuilder() : null;
        }

        public final void setCapabilityOptions(CapabilityOptions.BuilderImpl capabilityOptions) {
            this.capabilityOptions = capabilityOptions != null ? capabilityOptions.build() : null;
        }

        @Override
        public final Builder capabilityOptions(CapabilityOptions capabilityOptions) {
            this.capabilityOptions = capabilityOptions;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePartnershipRequest build() {
            return new CreatePartnershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
