/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMappingRequest extends B2BiRequest implements
        ToCopyableBuilder<GenerateMappingRequest.Builder, GenerateMappingRequest> {
    private static final SdkField<String> INPUT_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputFileContent").getter(getter(GenerateMappingRequest::inputFileContent))
            .setter(setter(Builder::inputFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileContent").build()).build();

    private static final SdkField<String> OUTPUT_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputFileContent").getter(getter(GenerateMappingRequest::outputFileContent))
            .setter(setter(Builder::outputFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFileContent").build()).build();

    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingType").getter(getter(GenerateMappingRequest::mappingTypeAsString))
            .setter(setter(Builder::mappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_CONTENT_FIELD,
            OUTPUT_FILE_CONTENT_FIELD, MAPPING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inputFileContent;

    private final String outputFileContent;

    private final String mappingType;

    private GenerateMappingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFileContent = builder.inputFileContent;
        this.outputFileContent = builder.outputFileContent;
        this.mappingType = builder.mappingType;
    }

    /**
     * <p>
     * Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a starting point for the
     * mapping.
     * </p>
     * 
     * @return Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a starting point
     *         for the mapping.
     */
    public final String inputFileContent() {
        return inputFileContent;
    }

    /**
     * <p>
     * Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a target for the mapping.
     * </p>
     * 
     * @return Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a target for the
     *         mapping.
     */
    public final String outputFileContent() {
        return outputFileContent;
    }

    /**
     * <p>
     * Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
     * @see MappingType
     */
    public final MappingType mappingType() {
        return MappingType.fromValue(mappingType);
    }

    /**
     * <p>
     * Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
     * @see MappingType
     */
    public final String mappingTypeAsString() {
        return mappingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(outputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMappingRequest)) {
            return false;
        }
        GenerateMappingRequest other = (GenerateMappingRequest) obj;
        return Objects.equals(inputFileContent(), other.inputFileContent())
                && Objects.equals(outputFileContent(), other.outputFileContent())
                && Objects.equals(mappingTypeAsString(), other.mappingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMappingRequest").add("InputFileContent", inputFileContent())
                .add("OutputFileContent", outputFileContent()).add("MappingType", mappingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputFileContent":
            return Optional.ofNullable(clazz.cast(inputFileContent()));
        case "outputFileContent":
            return Optional.ofNullable(clazz.cast(outputFileContent()));
        case "mappingType":
            return Optional.ofNullable(clazz.cast(mappingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputFileContent", INPUT_FILE_CONTENT_FIELD);
        map.put("outputFileContent", OUTPUT_FILE_CONTENT_FIELD);
        map.put("mappingType", MAPPING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMappingRequest, T> g) {
        return obj -> g.apply((GenerateMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, GenerateMappingRequest> {
        /**
         * <p>
         * Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a starting point for
         * the mapping.
         * </p>
         * 
         * @param inputFileContent
         *        Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a starting
         *        point for the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileContent(String inputFileContent);

        /**
         * <p>
         * Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a target for the
         * mapping.
         * </p>
         * 
         * @param outputFileContent
         *        Provide the contents of a sample X12 EDI file, either in JSON or XML format, to use as a target for
         *        the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFileContent(String outputFileContent);

        /**
         * <p>
         * Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
         * </p>
         * 
         * @param mappingType
         *        Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(String mappingType);

        /**
         * <p>
         * Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
         * </p>
         * 
         * @param mappingType
         *        Specify the mapping type: either <code>JSONATA</code> or <code>XSLT.</code>
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(MappingType mappingType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String inputFileContent;

        private String outputFileContent;

        private String mappingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMappingRequest model) {
            super(model);
            inputFileContent(model.inputFileContent);
            outputFileContent(model.outputFileContent);
            mappingType(model.mappingType);
        }

        public final String getInputFileContent() {
            return inputFileContent;
        }

        public final void setInputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
        }

        @Override
        public final Builder inputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
            return this;
        }

        public final String getOutputFileContent() {
            return outputFileContent;
        }

        public final void setOutputFileContent(String outputFileContent) {
            this.outputFileContent = outputFileContent;
        }

        @Override
        public final Builder outputFileContent(String outputFileContent) {
            this.outputFileContent = outputFileContent;
            return this;
        }

        public final String getMappingType() {
            return mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMappingRequest build() {
            return new GenerateMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
