/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPartnershipsResponse extends B2BiResponse implements
        ToCopyableBuilder<ListPartnershipsResponse.Builder, ListPartnershipsResponse> {
    private static final SdkField<List<PartnershipSummary>> PARTNERSHIPS_FIELD = SdkField
            .<List<PartnershipSummary>> builder(MarshallingType.LIST)
            .memberName("partnerships")
            .getter(getter(ListPartnershipsResponse::partnerships))
            .setter(setter(Builder::partnerships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnerships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartnershipSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartnershipSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPartnershipsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNERSHIPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PartnershipSummary> partnerships;

    private final String nextToken;

    private ListPartnershipsResponse(BuilderImpl builder) {
        super(builder);
        this.partnerships = builder.partnerships;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Partnerships property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartnerships() {
        return partnerships != null && !(partnerships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of your partnerships.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerships} method.
     * </p>
     * 
     * @return Specifies a list of your partnerships.
     */
    public final List<PartnershipSummary> partnerships() {
        return partnerships;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @return When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *         the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *         listing additional resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerships() ? partnerships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnershipsResponse)) {
            return false;
        }
        ListPartnershipsResponse other = (ListPartnershipsResponse) obj;
        return hasPartnerships() == other.hasPartnerships() && Objects.equals(partnerships(), other.partnerships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPartnershipsResponse").add("Partnerships", hasPartnerships() ? partnerships() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "partnerships":
            return Optional.ofNullable(clazz.cast(partnerships()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("partnerships", PARTNERSHIPS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPartnershipsResponse, T> g) {
        return obj -> g.apply((ListPartnershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPartnershipsResponse> {
        /**
         * <p>
         * Specifies a list of your partnerships.
         * </p>
         * 
         * @param partnerships
         *        Specifies a list of your partnerships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerships(Collection<PartnershipSummary> partnerships);

        /**
         * <p>
         * Specifies a list of your partnerships.
         * </p>
         * 
         * @param partnerships
         *        Specifies a list of your partnerships.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerships(PartnershipSummary... partnerships);

        /**
         * <p>
         * Specifies a list of your partnerships.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.PartnershipSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.PartnershipSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.PartnershipSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #partnerships(List<PartnershipSummary>)}.
         * 
         * @param partnerships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.PartnershipSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerships(java.util.Collection<PartnershipSummary>)
         */
        Builder partnerships(Consumer<PartnershipSummary.Builder>... partnerships);

        /**
         * <p>
         * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
         * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
         * additional resources.
         * </p>
         * 
         * @param nextToken
         *        When additional results are obtained from the command, a <code>NextToken</code> parameter is returned
         *        in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to
         *        continue listing additional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private List<PartnershipSummary> partnerships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnershipsResponse model) {
            super(model);
            partnerships(model.partnerships);
            nextToken(model.nextToken);
        }

        public final List<PartnershipSummary.Builder> getPartnerships() {
            List<PartnershipSummary.Builder> result = PartnershipListCopier.copyToBuilder(this.partnerships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerships(Collection<PartnershipSummary.BuilderImpl> partnerships) {
            this.partnerships = PartnershipListCopier.copyFromBuilder(partnerships);
        }

        @Override
        public final Builder partnerships(Collection<PartnershipSummary> partnerships) {
            this.partnerships = PartnershipListCopier.copy(partnerships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerships(PartnershipSummary... partnerships) {
            partnerships(Arrays.asList(partnerships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partnerships(Consumer<PartnershipSummary.Builder>... partnerships) {
            partnerships(Stream.of(partnerships).map(c -> PartnershipSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPartnershipsResponse build() {
            return new ListPartnershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
