/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransformersResponse extends B2BiResponse implements
        ToCopyableBuilder<ListTransformersResponse.Builder, ListTransformersResponse> {
    private static final SdkField<List<TransformerSummary>> TRANSFORMERS_FIELD = SdkField
            .<List<TransformerSummary>> builder(MarshallingType.LIST)
            .memberName("transformers")
            .getter(getter(ListTransformersResponse::transformers))
            .setter(setter(Builder::transformers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransformerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransformerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTransformersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TransformerSummary> transformers;

    private final String nextToken;

    private ListTransformersResponse(BuilderImpl builder) {
        super(builder);
        this.transformers = builder.transformers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transformers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformers() {
        return transformers != null && !(transformers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of one or more transformer objects.
     * </p>
     * <p>
     * For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code>
     * contains all the details for a specific transformer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformers} method.
     * </p>
     * 
     * @return Returns an array of one or more transformer objects.</p>
     *         <p>
     *         For each transformer, a <code>TransformerSummary</code> object is returned. The
     *         <code>TransformerSummary</code> contains all the details for a specific transformer.
     */
    public final List<TransformerSummary> transformers() {
        return transformers;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @return When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *         the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *         listing additional resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformers() ? transformers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransformersResponse)) {
            return false;
        }
        ListTransformersResponse other = (ListTransformersResponse) obj;
        return hasTransformers() == other.hasTransformers() && Objects.equals(transformers(), other.transformers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransformersResponse").add("Transformers", hasTransformers() ? transformers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformers":
            return Optional.ofNullable(clazz.cast(transformers()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformers", TRANSFORMERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransformersResponse, T> g) {
        return obj -> g.apply((ListTransformersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTransformersResponse> {
        /**
         * <p>
         * Returns an array of one or more transformer objects.
         * </p>
         * <p>
         * For each transformer, a <code>TransformerSummary</code> object is returned. The
         * <code>TransformerSummary</code> contains all the details for a specific transformer.
         * </p>
         * 
         * @param transformers
         *        Returns an array of one or more transformer objects.</p>
         *        <p>
         *        For each transformer, a <code>TransformerSummary</code> object is returned. The
         *        <code>TransformerSummary</code> contains all the details for a specific transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformers(Collection<TransformerSummary> transformers);

        /**
         * <p>
         * Returns an array of one or more transformer objects.
         * </p>
         * <p>
         * For each transformer, a <code>TransformerSummary</code> object is returned. The
         * <code>TransformerSummary</code> contains all the details for a specific transformer.
         * </p>
         * 
         * @param transformers
         *        Returns an array of one or more transformer objects.</p>
         *        <p>
         *        For each transformer, a <code>TransformerSummary</code> object is returned. The
         *        <code>TransformerSummary</code> contains all the details for a specific transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformers(TransformerSummary... transformers);

        /**
         * <p>
         * Returns an array of one or more transformer objects.
         * </p>
         * <p>
         * For each transformer, a <code>TransformerSummary</code> object is returned. The
         * <code>TransformerSummary</code> contains all the details for a specific transformer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.TransformerSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.TransformerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.TransformerSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #transformers(List<TransformerSummary>)}.
         * 
         * @param transformers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.TransformerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformers(java.util.Collection<TransformerSummary>)
         */
        Builder transformers(Consumer<TransformerSummary.Builder>... transformers);

        /**
         * <p>
         * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
         * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
         * additional resources.
         * </p>
         * 
         * @param nextToken
         *        When additional results are obtained from the command, a <code>NextToken</code> parameter is returned
         *        in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to
         *        continue listing additional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private List<TransformerSummary> transformers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransformersResponse model) {
            super(model);
            transformers(model.transformers);
            nextToken(model.nextToken);
        }

        public final List<TransformerSummary.Builder> getTransformers() {
            List<TransformerSummary.Builder> result = TransformerListCopier.copyToBuilder(this.transformers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformers(Collection<TransformerSummary.BuilderImpl> transformers) {
            this.transformers = TransformerListCopier.copyFromBuilder(transformers);
        }

        @Override
        public final Builder transformers(Collection<TransformerSummary> transformers) {
            this.transformers = TransformerListCopier.copy(transformers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformers(TransformerSummary... transformers) {
            transformers(Arrays.asList(transformers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformers(Consumer<TransformerSummary.Builder>... transformers) {
            transformers(Stream.of(transformers).map(c -> TransformerSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransformersResponse build() {
            return new ListTransformersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
