/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestConversionResponse extends B2BiResponse implements
        ToCopyableBuilder<TestConversionResponse.Builder, TestConversionResponse> {
    private static final SdkField<String> CONVERTED_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("convertedFileContent").getter(getter(TestConversionResponse::convertedFileContent))
            .setter(setter(Builder::convertedFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convertedFileContent").build())
            .build();

    private static final SdkField<List<String>> VALIDATION_MESSAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("validationMessages")
            .getter(getter(TestConversionResponse::validationMessages))
            .setter(setter(Builder::validationMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERTED_FILE_CONTENT_FIELD,
            VALIDATION_MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String convertedFileContent;

    private final List<String> validationMessages;

    private TestConversionResponse(BuilderImpl builder) {
        super(builder);
        this.convertedFileContent = builder.convertedFileContent;
        this.validationMessages = builder.validationMessages;
    }

    /**
     * <p>
     * Returns the converted file content.
     * </p>
     * 
     * @return Returns the converted file content.
     */
    public final String convertedFileContent() {
        return convertedFileContent;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationMessages() {
        return validationMessages != null && !(validationMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during the
     * conversion process. These messages include both standard EDI validation results and custom validation messages
     * when custom validation rules are configured. Custom validation messages provide detailed feedback on element
     * length constraints, code list validations, and element requirement checks applied during the outbound EDI
     * generation process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationMessages} method.
     * </p>
     * 
     * @return Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during
     *         the conversion process. These messages include both standard EDI validation results and custom validation
     *         messages when custom validation rules are configured. Custom validation messages provide detailed
     *         feedback on element length constraints, code list validations, and element requirement checks applied
     *         during the outbound EDI generation process.
     */
    public final List<String> validationMessages() {
        return validationMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(convertedFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationMessages() ? validationMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConversionResponse)) {
            return false;
        }
        TestConversionResponse other = (TestConversionResponse) obj;
        return Objects.equals(convertedFileContent(), other.convertedFileContent())
                && hasValidationMessages() == other.hasValidationMessages()
                && Objects.equals(validationMessages(), other.validationMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestConversionResponse").add("ConvertedFileContent", convertedFileContent())
                .add("ValidationMessages", hasValidationMessages() ? validationMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "convertedFileContent":
            return Optional.ofNullable(clazz.cast(convertedFileContent()));
        case "validationMessages":
            return Optional.ofNullable(clazz.cast(validationMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("convertedFileContent", CONVERTED_FILE_CONTENT_FIELD);
        map.put("validationMessages", VALIDATION_MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestConversionResponse, T> g) {
        return obj -> g.apply((TestConversionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestConversionResponse> {
        /**
         * <p>
         * Returns the converted file content.
         * </p>
         * 
         * @param convertedFileContent
         *        Returns the converted file content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder convertedFileContent(String convertedFileContent);

        /**
         * <p>
         * Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during the
         * conversion process. These messages include both standard EDI validation results and custom validation
         * messages when custom validation rules are configured. Custom validation messages provide detailed feedback on
         * element length constraints, code list validations, and element requirement checks applied during the outbound
         * EDI generation process.
         * </p>
         * 
         * @param validationMessages
         *        Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during
         *        the conversion process. These messages include both standard EDI validation results and custom
         *        validation messages when custom validation rules are configured. Custom validation messages provide
         *        detailed feedback on element length constraints, code list validations, and element requirement checks
         *        applied during the outbound EDI generation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessages(Collection<String> validationMessages);

        /**
         * <p>
         * Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during the
         * conversion process. These messages include both standard EDI validation results and custom validation
         * messages when custom validation rules are configured. Custom validation messages provide detailed feedback on
         * element length constraints, code list validations, and element requirement checks applied during the outbound
         * EDI generation process.
         * </p>
         * 
         * @param validationMessages
         *        Returns an array of validation messages that Amazon Web Services B2B Data Interchange generates during
         *        the conversion process. These messages include both standard EDI validation results and custom
         *        validation messages when custom validation rules are configured. Custom validation messages provide
         *        detailed feedback on element length constraints, code list validations, and element requirement checks
         *        applied during the outbound EDI generation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMessages(String... validationMessages);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String convertedFileContent;

        private List<String> validationMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestConversionResponse model) {
            super(model);
            convertedFileContent(model.convertedFileContent);
            validationMessages(model.validationMessages);
        }

        public final String getConvertedFileContent() {
            return convertedFileContent;
        }

        public final void setConvertedFileContent(String convertedFileContent) {
            this.convertedFileContent = convertedFileContent;
        }

        @Override
        public final Builder convertedFileContent(String convertedFileContent) {
            this.convertedFileContent = convertedFileContent;
            return this;
        }

        public final Collection<String> getValidationMessages() {
            if (validationMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return validationMessages;
        }

        public final void setValidationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
        }

        @Override
        public final Builder validationMessages(Collection<String> validationMessages) {
            this.validationMessages = ValidationMessagesCopier.copy(validationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMessages(String... validationMessages) {
            validationMessages(Arrays.asList(validationMessages));
            return this;
        }

        @Override
        public TestConversionResponse build() {
            return new TestConversionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
