/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a validation rule that modifies the requirement status of a specific X12 element within a segment. This rule
 * allows you to make optional elements mandatory or mandatory elements optional, providing flexibility to accommodate
 * different trading partner requirements and business rules. The rule targets a specific element position within a
 * segment and sets its requirement status to either OPTIONAL or MANDATORY.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12ElementRequirementValidationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<X12ElementRequirementValidationRule.Builder, X12ElementRequirementValidationRule> {
    private static final SdkField<String> ELEMENT_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("elementPosition").getter(getter(X12ElementRequirementValidationRule::elementPosition))
            .setter(setter(Builder::elementPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementPosition").build()).build();

    private static final SdkField<String> REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requirement").getter(getter(X12ElementRequirementValidationRule::requirementAsString))
            .setter(setter(Builder::requirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requirement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_POSITION_FIELD,
            REQUIREMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String elementPosition;

    private final String requirement;

    private X12ElementRequirementValidationRule(BuilderImpl builder) {
        this.elementPosition = builder.elementPosition;
        this.requirement = builder.requirement;
    }

    /**
     * <p>
     * Specifies the position of the element within an X12 segment for which the requirement status will be modified.
     * The format follows the pattern of segment identifier followed by element position (e.g., "ST-01" for the first
     * element of the ST segment).
     * </p>
     * 
     * @return Specifies the position of the element within an X12 segment for which the requirement status will be
     *         modified. The format follows the pattern of segment identifier followed by element position (e.g.,
     *         "ST-01" for the first element of the ST segment).
     */
    public final String elementPosition() {
        return elementPosition;
    }

    /**
     * <p>
     * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the
     * element may be omitted) or MANDATORY (the element must be present).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirement} will
     * return {@link ElementRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirementAsString}.
     * </p>
     * 
     * @return Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL
     *         (the element may be omitted) or MANDATORY (the element must be present).
     * @see ElementRequirement
     */
    public final ElementRequirement requirement() {
        return ElementRequirement.fromValue(requirement);
    }

    /**
     * <p>
     * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the
     * element may be omitted) or MANDATORY (the element must be present).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requirement} will
     * return {@link ElementRequirement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requirementAsString}.
     * </p>
     * 
     * @return Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL
     *         (the element may be omitted) or MANDATORY (the element must be present).
     * @see ElementRequirement
     */
    public final String requirementAsString() {
        return requirement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elementPosition());
        hashCode = 31 * hashCode + Objects.hashCode(requirementAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12ElementRequirementValidationRule)) {
            return false;
        }
        X12ElementRequirementValidationRule other = (X12ElementRequirementValidationRule) obj;
        return Objects.equals(elementPosition(), other.elementPosition())
                && Objects.equals(requirementAsString(), other.requirementAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12ElementRequirementValidationRule").add("ElementPosition", elementPosition())
                .add("Requirement", requirementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "elementPosition":
            return Optional.ofNullable(clazz.cast(elementPosition()));
        case "requirement":
            return Optional.ofNullable(clazz.cast(requirementAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("elementPosition", ELEMENT_POSITION_FIELD);
        map.put("requirement", REQUIREMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12ElementRequirementValidationRule, T> g) {
        return obj -> g.apply((X12ElementRequirementValidationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12ElementRequirementValidationRule> {
        /**
         * <p>
         * Specifies the position of the element within an X12 segment for which the requirement status will be
         * modified. The format follows the pattern of segment identifier followed by element position (e.g., "ST-01"
         * for the first element of the ST segment).
         * </p>
         * 
         * @param elementPosition
         *        Specifies the position of the element within an X12 segment for which the requirement status will be
         *        modified. The format follows the pattern of segment identifier followed by element position (e.g.,
         *        "ST-01" for the first element of the ST segment).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementPosition(String elementPosition);

        /**
         * <p>
         * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the
         * element may be omitted) or MANDATORY (the element must be present).
         * </p>
         * 
         * @param requirement
         *        Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL
         *        (the element may be omitted) or MANDATORY (the element must be present).
         * @see ElementRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElementRequirement
         */
        Builder requirement(String requirement);

        /**
         * <p>
         * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the
         * element may be omitted) or MANDATORY (the element must be present).
         * </p>
         * 
         * @param requirement
         *        Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL
         *        (the element may be omitted) or MANDATORY (the element must be present).
         * @see ElementRequirement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElementRequirement
         */
        Builder requirement(ElementRequirement requirement);
    }

    static final class BuilderImpl implements Builder {
        private String elementPosition;

        private String requirement;

        private BuilderImpl() {
        }

        private BuilderImpl(X12ElementRequirementValidationRule model) {
            elementPosition(model.elementPosition);
            requirement(model.requirement);
        }

        public final String getElementPosition() {
            return elementPosition;
        }

        public final void setElementPosition(String elementPosition) {
            this.elementPosition = elementPosition;
        }

        @Override
        public final Builder elementPosition(String elementPosition) {
            this.elementPosition = elementPosition;
            return this;
        }

        public final String getRequirement() {
            return requirement;
        }

        public final void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        @Override
        public final Builder requirement(String requirement) {
            this.requirement = requirement;
            return this;
        }

        @Override
        public final Builder requirement(ElementRequirement requirement) {
            this.requirement(requirement == null ? null : requirement.toString());
            return this;
        }

        @Override
        public X12ElementRequirementValidationRule build() {
            return new X12ElementRequirementValidationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
