/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackupPlanRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateBackupPlanRequest.Builder, UpdateBackupPlanRequest> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBackupPlanRequest::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupPlanId").build()).build();

    private static final SdkField<BackupPlanInput> BACKUP_PLAN_FIELD = SdkField
            .<BackupPlanInput> builder(MarshallingType.SDK_POJO).getter(getter(UpdateBackupPlanRequest::backupPlan))
            .setter(setter(Builder::backupPlan)).constructor(BackupPlanInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            BACKUP_PLAN_FIELD));

    private final String backupPlanId;

    private final BackupPlanInput backupPlan;

    private UpdateBackupPlanRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupPlan = builder.backupPlan;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
     * <code>Rules</code>.
     * </p>
     * 
     * @return Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
     *         <code>Rules</code>.
     */
    public BackupPlanInput backupPlan() {
        return backupPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlan());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackupPlanRequest)) {
            return false;
        }
        UpdateBackupPlanRequest other = (UpdateBackupPlanRequest) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(backupPlan(), other.backupPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateBackupPlanRequest").add("BackupPlanId", backupPlanId()).add("BackupPlan", backupPlan())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupPlan":
            return Optional.ofNullable(clazz.cast(backupPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackupPlanRequest, T> g) {
        return obj -> g.apply((UpdateBackupPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBackupPlanRequest> {
        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         * <code>Rules</code>.
         * </p>
         * 
         * @param backupPlan
         *        Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         *        <code>Rules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlan(BackupPlanInput backupPlan);

        /**
         * <p>
         * Specifies the body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         * <code>Rules</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link BackupPlanInput.Builder} avoiding the need to
         * create one manually via {@link BackupPlanInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupPlanInput.Builder#build()} is called immediately and its
         * result is passed to {@link #backupPlan(BackupPlanInput)}.
         * 
         * @param backupPlan
         *        a consumer that will call methods on {@link BackupPlanInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlan(BackupPlanInput)
         */
        default Builder backupPlan(Consumer<BackupPlanInput.Builder> backupPlan) {
            return backupPlan(BackupPlanInput.builder().applyMutation(backupPlan).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupPlanId;

        private BackupPlanInput backupPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackupPlanRequest model) {
            super(model);
            backupPlanId(model.backupPlanId);
            backupPlan(model.backupPlan);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final BackupPlanInput.Builder getBackupPlan() {
            return backupPlan != null ? backupPlan.toBuilder() : null;
        }

        @Override
        public final Builder backupPlan(BackupPlanInput backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final void setBackupPlan(BackupPlanInput.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBackupPlanRequest build() {
            return new UpdateBackupPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
