/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBackupSelectionRequest extends BackupRequest implements
        ToCopyableBuilder<DeleteBackupSelectionRequest.Builder, DeleteBackupSelectionRequest> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteBackupSelectionRequest::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupPlanId").build()).build();

    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteBackupSelectionRequest::selectionId)).setter(setter(Builder::selectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("selectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            SELECTION_ID_FIELD));

    private final String backupPlanId;

    private final String selectionId;

    private DeleteBackupSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.selectionId = builder.selectionId;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * Uniquely identifies the body of a request to assign a set of resources to a backup plan.
     * </p>
     * 
     * @return Uniquely identifies the body of a request to assign a set of resources to a backup plan.
     */
    public String selectionId() {
        return selectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(selectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackupSelectionRequest)) {
            return false;
        }
        DeleteBackupSelectionRequest other = (DeleteBackupSelectionRequest) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(selectionId(), other.selectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteBackupSelectionRequest").add("BackupPlanId", backupPlanId())
                .add("SelectionId", selectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "SelectionId":
            return Optional.ofNullable(clazz.cast(selectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackupSelectionRequest, T> g) {
        return obj -> g.apply((DeleteBackupSelectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBackupSelectionRequest> {
        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * Uniquely identifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * 
         * @param selectionId
         *        Uniquely identifies the body of a request to assign a set of resources to a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionId(String selectionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupPlanId;

        private String selectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackupSelectionRequest model) {
            super(model);
            backupPlanId(model.backupPlanId);
            selectionId(model.selectionId);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final String getSelectionId() {
            return selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBackupSelectionRequest build() {
            return new DeleteBackupSelectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
