/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartBackupJobRequest extends BackupRequest implements
        ToCopyableBuilder<StartBackupJobRequest.Builder, StartBackupJobRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBackupJobRequest::backupVaultName)).setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBackupJobRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBackupJobRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartBackupJobRequest::idempotencyToken)).setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<Long> START_WINDOW_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartBackupJobRequest::startWindowMinutes)).setter(setter(Builder::startWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowMinutes").build())
            .build();

    private static final SdkField<Long> COMPLETE_WINDOW_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(StartBackupJobRequest::completeWindowMinutes)).setter(setter(Builder::completeWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteWindowMinutes").build())
            .build();

    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartBackupJobRequest::lifecycle)).setter(setter(Builder::lifecycle)).constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<Map<String, String>> RECOVERY_POINT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(StartBackupJobRequest::recoveryPointTags))
            .setter(setter(Builder::recoveryPointTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            RESOURCE_ARN_FIELD, IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, START_WINDOW_MINUTES_FIELD,
            COMPLETE_WINDOW_MINUTES_FIELD, LIFECYCLE_FIELD, RECOVERY_POINT_TAGS_FIELD));

    private final String backupVaultName;

    private final String resourceArn;

    private final String iamRoleArn;

    private final String idempotencyToken;

    private final Long startWindowMinutes;

    private final Long completeWindowMinutes;

    private final Lifecycle lifecycle;

    private final Map<String, String> recoveryPointTags;

    private StartBackupJobRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.resourceArn = builder.resourceArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.startWindowMinutes = builder.startWindowMinutes;
        this.completeWindowMinutes = builder.completeWindowMinutes;
        this.lifecycle = builder.lifecycle;
        this.recoveryPointTags = builder.recoveryPointTags;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the AWS Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the AWS Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */
    public String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A customer chosen string that can be used to distinguish between calls to <code>StartBackupJob</code>.
     * </p>
     * 
     * @return A customer chosen string that can be used to distinguish between calls to <code>StartBackupJob</code>.
     */
    public String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * The amount of time in minutes before beginning a backup.
     * </p>
     * 
     * @return The amount of time in minutes before beginning a backup.
     */
    public Long startWindowMinutes() {
        return startWindowMinutes;
    }

    /**
     * <p>
     * The amount of time AWS Backup attempts a backup before canceling the job and returning an error.
     * </p>
     * 
     * @return The amount of time AWS Backup attempts a backup before canceling the job and returning an error.
     */
    public Long completeWindowMinutes() {
        return completeWindowMinutes;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup
     * will transition and expire backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
     * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
     *         Backup will transition and expire backups automatically according to the lifecycle that you define. </p>
     *         <p>
     *         Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     *         the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting.
     *         The “transition to cold after days” setting cannot be changed after a backup has been transitioned to
     *         cold.
     */
    public Lifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * Returns true if the RecoveryPointTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecoveryPointTags() {
        return recoveryPointTags != null && !(recoveryPointTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecoveryPointTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return To help organize your resources, you can assign your own metadata to the resources that you create. Each
     *         tag is a key-value pair.
     */
    public Map<String, String> recoveryPointTags() {
        return recoveryPointTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(completeWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBackupJobRequest)) {
            return false;
        }
        StartBackupJobRequest other = (StartBackupJobRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(startWindowMinutes(), other.startWindowMinutes())
                && Objects.equals(completeWindowMinutes(), other.completeWindowMinutes())
                && Objects.equals(lifecycle(), other.lifecycle())
                && Objects.equals(recoveryPointTags(), other.recoveryPointTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartBackupJobRequest").add("BackupVaultName", backupVaultName())
                .add("ResourceArn", resourceArn()).add("IamRoleArn", iamRoleArn()).add("IdempotencyToken", idempotencyToken())
                .add("StartWindowMinutes", startWindowMinutes()).add("CompleteWindowMinutes", completeWindowMinutes())
                .add("Lifecycle", lifecycle())
                .add("RecoveryPointTags", recoveryPointTags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "StartWindowMinutes":
            return Optional.ofNullable(clazz.cast(startWindowMinutes()));
        case "CompleteWindowMinutes":
            return Optional.ofNullable(clazz.cast(completeWindowMinutes()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "RecoveryPointTags":
            return Optional.ofNullable(clazz.cast(recoveryPointTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBackupJobRequest, T> g) {
        return obj -> g.apply((StartBackupJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartBackupJobRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the AWS Region where they are created. They consist of
         * lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the AWS Region where they are created. They consist
         *        of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param resourceArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A customer chosen string that can be used to distinguish between calls to <code>StartBackupJob</code>.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer chosen string that can be used to distinguish between calls to <code>StartBackupJob</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * The amount of time in minutes before beginning a backup.
         * </p>
         * 
         * @param startWindowMinutes
         *        The amount of time in minutes before beginning a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowMinutes(Long startWindowMinutes);

        /**
         * <p>
         * The amount of time AWS Backup attempts a backup before canceling the job and returning an error.
         * </p>
         * 
         * @param completeWindowMinutes
         *        The amount of time AWS Backup attempts a backup before canceling the job and returning an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeWindowMinutes(Long completeWindowMinutes);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup will transition and expire backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         *        AWS Backup will transition and expire backups automatically according to the lifecycle that you
         *        define. </p>
         *        <p>
         *        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         *        Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after
         *        days” setting. The “transition to cold after days” setting cannot be changed after a backup has been
         *        transitioned to cold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup will transition and expire backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * This is a convenience that creates an instance of the {@link Lifecycle.Builder} avoiding the need to create
         * one manually via {@link Lifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag
         * is a key-value pair.
         * </p>
         * 
         * @param recoveryPointTags
         *        To help organize your resources, you can assign your own metadata to the resources that you create.
         *        Each tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointTags(Map<String, String> recoveryPointTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String resourceArn;

        private String iamRoleArn;

        private String idempotencyToken;

        private Long startWindowMinutes;

        private Long completeWindowMinutes;

        private Lifecycle lifecycle;

        private Map<String, String> recoveryPointTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartBackupJobRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            resourceArn(model.resourceArn);
            iamRoleArn(model.iamRoleArn);
            idempotencyToken(model.idempotencyToken);
            startWindowMinutes(model.startWindowMinutes);
            completeWindowMinutes(model.completeWindowMinutes);
            lifecycle(model.lifecycle);
            recoveryPointTags(model.recoveryPointTags);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Long getStartWindowMinutes() {
            return startWindowMinutes;
        }

        @Override
        public final Builder startWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
            return this;
        }

        public final void setStartWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
        }

        public final Long getCompleteWindowMinutes() {
            return completeWindowMinutes;
        }

        @Override
        public final Builder completeWindowMinutes(Long completeWindowMinutes) {
            this.completeWindowMinutes = completeWindowMinutes;
            return this;
        }

        public final void setCompleteWindowMinutes(Long completeWindowMinutes) {
            this.completeWindowMinutes = completeWindowMinutes;
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final Map<String, String> getRecoveryPointTags() {
            return recoveryPointTags;
        }

        @Override
        public final Builder recoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
            return this;
        }

        public final void setRecoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBackupJobRequest build() {
            return new StartBackupJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
