/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a copy job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyJob implements SdkPojo, Serializable, ToCopyableBuilder<CopyJob.Builder, CopyJob> {
    private static final SdkField<String> COPY_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::copyJobId)).setter(setter(Builder::copyJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobId").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::sourceBackupVaultArn)).setter(setter(Builder::sourceBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build())
            .build();

    private static final SdkField<String> SOURCE_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::sourceRecoveryPointArn)).setter(setter(Builder::sourceRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRecoveryPointArn").build())
            .build();

    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::destinationBackupVaultArn)).setter(setter(Builder::destinationBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build())
            .build();

    private static final SdkField<String> DESTINATION_RECOVERY_POINT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::destinationRecoveryPointArn))
            .setter(setter(Builder::destinationRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRecoveryPointArn")
                    .build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CopyJob::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CopyJob::completionDate)).setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CopyJob::backupSizeInBytes)).setter(setter(Builder::backupSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField
            .<RecoveryPointCreator> builder(MarshallingType.SDK_POJO).getter(getter(CopyJob::createdBy))
            .setter(setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyJob::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_ID_FIELD,
            SOURCE_BACKUP_VAULT_ARN_FIELD, SOURCE_RECOVERY_POINT_ARN_FIELD, DESTINATION_BACKUP_VAULT_ARN_FIELD,
            DESTINATION_RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATE_FIELD,
            STATUS_MESSAGE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, CREATED_BY_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String copyJobId;

    private final String sourceBackupVaultArn;

    private final String sourceRecoveryPointArn;

    private final String destinationBackupVaultArn;

    private final String destinationRecoveryPointArn;

    private final String resourceArn;

    private final Instant creationDate;

    private final Instant completionDate;

    private final String state;

    private final String statusMessage;

    private final Long backupSizeInBytes;

    private final String iamRoleArn;

    private final RecoveryPointCreator createdBy;

    private final String resourceType;

    private CopyJob(BuilderImpl builder) {
        this.copyJobId = builder.copyJobId;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.sourceRecoveryPointArn = builder.sourceRecoveryPointArn;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.destinationRecoveryPointArn = builder.destinationRecoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.createdBy = builder.createdBy;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * Uniquely identifies a copy job.
     * </p>
     * 
     * @return Uniquely identifies a copy job.
     */
    public String copyJobId() {
        return copyJobId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public String sourceBackupVaultArn() {
        return sourceBackupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a source recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a source recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public String sourceRecoveryPointArn() {
        return sourceRecoveryPointArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public String destinationBackupVaultArn() {
        return destinationBackupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a destination recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a destination recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public String destinationRecoveryPointArn() {
        return destinationRecoveryPointArn;
    }

    /**
     * <p>
     * The AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
     * Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return The AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an
     *         Amazon Relational Database Service (Amazon RDS) database.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * CreationDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26,
     * 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value
     *         of CreationDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     *         January 26, 2018 12:11:30.087 AM.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of
     * CompletionDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26,
     * 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value
     *         of CompletionDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     *         January 26, 2018 12:11:30.087 AM.
     */
    public Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The current state of a copy job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CopyJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a copy job.
     * @see CopyJobState
     */
    public CopyJobState state() {
        return CopyJobState.fromValue(state);
    }

    /**
     * <p>
     * The current state of a copy job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CopyJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of a copy job.
     * @see CopyJobState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A detailed message explaining the status of the job to copy a resource.
     * </p>
     * 
     * @return A detailed message explaining the status of the job to copy a resource.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The size, in bytes, of a copy job.
     * </p>
     * 
     * @return The size, in bytes, of a copy job.
     */
    public Long backupSizeInBytes() {
        return backupSizeInBytes;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to copy the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to copy the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public RecoveryPointCreator createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The type of AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an
     * Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return The type of AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or
     *         an Amazon Relational Database Service (Amazon RDS) database.
     */
    public String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(copyJobId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJob)) {
            return false;
        }
        CopyJob other = (CopyJob) obj;
        return Objects.equals(copyJobId(), other.copyJobId())
                && Objects.equals(sourceBackupVaultArn(), other.sourceBackupVaultArn())
                && Objects.equals(sourceRecoveryPointArn(), other.sourceRecoveryPointArn())
                && Objects.equals(destinationBackupVaultArn(), other.destinationBackupVaultArn())
                && Objects.equals(destinationRecoveryPointArn(), other.destinationRecoveryPointArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(backupSizeInBytes(), other.backupSizeInBytes())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyJob").add("CopyJobId", copyJobId()).add("SourceBackupVaultArn", sourceBackupVaultArn())
                .add("SourceRecoveryPointArn", sourceRecoveryPointArn())
                .add("DestinationBackupVaultArn", destinationBackupVaultArn())
                .add("DestinationRecoveryPointArn", destinationRecoveryPointArn()).add("ResourceArn", resourceArn())
                .add("CreationDate", creationDate()).add("CompletionDate", completionDate()).add("State", stateAsString())
                .add("StatusMessage", statusMessage()).add("BackupSizeInBytes", backupSizeInBytes())
                .add("IamRoleArn", iamRoleArn()).add("CreatedBy", createdBy()).add("ResourceType", resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyJobId":
            return Optional.ofNullable(clazz.cast(copyJobId()));
        case "SourceBackupVaultArn":
            return Optional.ofNullable(clazz.cast(sourceBackupVaultArn()));
        case "SourceRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(sourceRecoveryPointArn()));
        case "DestinationBackupVaultArn":
            return Optional.ofNullable(clazz.cast(destinationBackupVaultArn()));
        case "DestinationRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(destinationRecoveryPointArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "BackupSizeInBytes":
            return Optional.ofNullable(clazz.cast(backupSizeInBytes()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyJob, T> g) {
        return obj -> g.apply((CopyJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyJob> {
        /**
         * <p>
         * Uniquely identifies a copy job.
         * </p>
         * 
         * @param copyJobId
         *        Uniquely identifies a copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyJobId(String copyJobId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param sourceBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupVaultArn(String sourceBackupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies a source recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param sourceRecoveryPointArn
         *        An ARN that uniquely identifies a source recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRecoveryPointArn(String sourceRecoveryPointArn);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param destinationBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBackupVaultArn(String destinationBackupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies a destination recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param destinationRecoveryPointArn
         *        An ARN that uniquely identifies a destination recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRecoveryPointArn(String destinationRecoveryPointArn);

        /**
         * <p>
         * The AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
         * Relational Database Service (Amazon RDS) database.
         * </p>
         * 
         * @param resourceArn
         *        The AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an
         *        Amazon Relational Database Service (Amazon RDS) database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of
         * CreationDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
         * 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of CreationDate is accurate to milliseconds. For example, the value 1516925490.087 represents
         *        Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of
         * CompletionDate is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January
         * 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The
         *        value of CompletionDate is accurate to milliseconds. For example, the value 1516925490.087 represents
         *        Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The current state of a copy job.
         * </p>
         * 
         * @param state
         *        The current state of a copy job.
         * @see CopyJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyJobState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of a copy job.
         * </p>
         * 
         * @param state
         *        The current state of a copy job.
         * @see CopyJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyJobState
         */
        Builder state(CopyJobState state);

        /**
         * <p>
         * A detailed message explaining the status of the job to copy a resource.
         * </p>
         * 
         * @param statusMessage
         *        A detailed message explaining the status of the job to copy a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The size, in bytes, of a copy job.
         * </p>
         * 
         * @param backupSizeInBytes
         *        The size, in bytes, of a copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeInBytes(Long backupSizeInBytes);

        /**
         * <p>
         * Specifies the IAM role ARN used to copy the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to copy the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(RecoveryPointCreator createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link RecoveryPointCreator.Builder} avoiding the need
         * to create one manually via {@link RecoveryPointCreator#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecoveryPointCreator.Builder#build()} is called immediately and
         * its result is passed to {@link #createdBy(RecoveryPointCreator)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link RecoveryPointCreator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(RecoveryPointCreator)
         */
        default Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return createdBy(RecoveryPointCreator.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The type of AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an
         * Amazon Relational Database Service (Amazon RDS) database.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume
         *        or an Amazon Relational Database Service (Amazon RDS) database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String copyJobId;

        private String sourceBackupVaultArn;

        private String sourceRecoveryPointArn;

        private String destinationBackupVaultArn;

        private String destinationRecoveryPointArn;

        private String resourceArn;

        private Instant creationDate;

        private Instant completionDate;

        private String state;

        private String statusMessage;

        private Long backupSizeInBytes;

        private String iamRoleArn;

        private RecoveryPointCreator createdBy;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJob model) {
            copyJobId(model.copyJobId);
            sourceBackupVaultArn(model.sourceBackupVaultArn);
            sourceRecoveryPointArn(model.sourceRecoveryPointArn);
            destinationBackupVaultArn(model.destinationBackupVaultArn);
            destinationRecoveryPointArn(model.destinationRecoveryPointArn);
            resourceArn(model.resourceArn);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            state(model.state);
            statusMessage(model.statusMessage);
            backupSizeInBytes(model.backupSizeInBytes);
            iamRoleArn(model.iamRoleArn);
            createdBy(model.createdBy);
            resourceType(model.resourceType);
        }

        public final String getCopyJobId() {
            return copyJobId;
        }

        @Override
        public final Builder copyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
            return this;
        }

        public final void setCopyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
        }

        public final String getSourceBackupVaultArn() {
            return sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        public final String getSourceRecoveryPointArn() {
            return sourceRecoveryPointArn;
        }

        @Override
        public final Builder sourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
            return this;
        }

        public final void setSourceRecoveryPointArn(String sourceRecoveryPointArn) {
            this.sourceRecoveryPointArn = sourceRecoveryPointArn;
        }

        public final String getDestinationBackupVaultArn() {
            return destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        public final String getDestinationRecoveryPointArn() {
            return destinationRecoveryPointArn;
        }

        @Override
        public final Builder destinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
            return this;
        }

        public final void setDestinationRecoveryPointArn(String destinationRecoveryPointArn) {
            this.destinationRecoveryPointArn = destinationRecoveryPointArn;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CopyJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Long getBackupSizeInBytes() {
            return backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public CopyJob build() {
            return new CopyJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
