/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupJob> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::backupJobId)).setter(BackupJob.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupJobId").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::backupVaultName)).setter(BackupJob.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::backupVaultArn)).setter(BackupJob.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::recoveryPointArn)).setter(BackupJob.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::resourceArn)).setter(BackupJob.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupJob.getter(BackupJob::creationDate)).setter(BackupJob.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupJob.getter(BackupJob::completionDate)).setter(BackupJob.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::stateAsString)).setter(BackupJob.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::statusMessage)).setter(BackupJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> PERCENT_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::percentDone)).setter(BackupJob.setter(Builder::percentDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentDone").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BackupJob.getter(BackupJob::backupSizeInBytes)).setter(BackupJob.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::iamRoleArn)).setter(BackupJob.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BackupJob.getter(BackupJob::createdBy)).setter(BackupJob.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> EXPECTED_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupJob.getter(BackupJob::expectedCompletionDate)).setter(BackupJob.setter(Builder::expectedCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCompletionDate").build()}).build();
    private static final SdkField<Instant> START_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupJob.getter(BackupJob::startBy)).setter(BackupJob.setter(Builder::startBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartBy").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupJob.getter(BackupJob::resourceType)).setter(BackupJob.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BackupJob.getter(BackupJob::bytesTransferred)).setter(BackupJob.setter(Builder::bytesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, PERCENT_DONE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, CREATED_BY_FIELD, EXPECTED_COMPLETION_DATE_FIELD, START_BY_FIELD, RESOURCE_TYPE_FIELD, BYTES_TRANSFERRED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupJobId;
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String recoveryPointArn;
    private final String resourceArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String state;
    private final String statusMessage;
    private final String percentDone;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final RecoveryPointCreator createdBy;
    private final Instant expectedCompletionDate;
    private final Instant startBy;
    private final String resourceType;
    private final Long bytesTransferred;

    private BackupJob(BuilderImpl builder) {
        this.backupJobId = builder.backupJobId;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.percentDone = builder.percentDone;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.createdBy = builder.createdBy;
        this.expectedCompletionDate = builder.expectedCompletionDate;
        this.startBy = builder.startBy;
        this.resourceType = builder.resourceType;
        this.bytesTransferred = builder.bytesTransferred;
    }

    public String backupJobId() {
        return this.backupJobId;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant completionDate() {
        return this.completionDate;
    }

    public BackupJobState state() {
        return BackupJobState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String percentDone() {
        return this.percentDone;
    }

    public Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public String iamRoleArn() {
        return this.iamRoleArn;
    }

    public RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public Instant expectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public Instant startBy() {
        return this.startBy;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesTransferred());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupJob)) {
            return false;
        }
        BackupJob other = (BackupJob)obj;
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.percentDone(), other.percentDone()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.expectedCompletionDate(), other.expectedCompletionDate()) && Objects.equals(this.startBy(), other.startBy()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.bytesTransferred(), other.bytesTransferred());
    }

    public String toString() {
        return ToString.builder((String)"BackupJob").add("BackupJobId", (Object)this.backupJobId()).add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("ResourceArn", (Object)this.resourceArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("PercentDone", (Object)this.percentDone()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("CreatedBy", (Object)this.createdBy()).add("ExpectedCompletionDate", (Object)this.expectedCompletionDate()).add("StartBy", (Object)this.startBy()).add("ResourceType", (Object)this.resourceType()).add("BytesTransferred", (Object)this.bytesTransferred()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "PercentDone": {
                return Optional.ofNullable(clazz.cast(this.percentDone()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ExpectedCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.expectedCompletionDate()));
            }
            case "StartBy": {
                return Optional.ofNullable(clazz.cast(this.startBy()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "BytesTransferred": {
                return Optional.ofNullable(clazz.cast(this.bytesTransferred()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupJob, T> g) {
        return obj -> g.apply((BackupJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupJobId;
        private String backupVaultName;
        private String backupVaultArn;
        private String recoveryPointArn;
        private String resourceArn;
        private Instant creationDate;
        private Instant completionDate;
        private String state;
        private String statusMessage;
        private String percentDone;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private RecoveryPointCreator createdBy;
        private Instant expectedCompletionDate;
        private Instant startBy;
        private String resourceType;
        private Long bytesTransferred;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupJob model) {
            this.backupJobId(model.backupJobId);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.recoveryPointArn(model.recoveryPointArn);
            this.resourceArn(model.resourceArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.percentDone(model.percentDone);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.createdBy(model.createdBy);
            this.expectedCompletionDate(model.expectedCompletionDate);
            this.startBy(model.startBy);
            this.resourceType(model.resourceType);
            this.bytesTransferred(model.bytesTransferred);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BackupJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getPercentDone() {
            return this.percentDone;
        }

        @Override
        public final Builder percentDone(String percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final void setPercentDone(String percentDone) {
            this.percentDone = percentDone;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getExpectedCompletionDate() {
            return this.expectedCompletionDate;
        }

        @Override
        public final Builder expectedCompletionDate(Instant expectedCompletionDate) {
            this.expectedCompletionDate = expectedCompletionDate;
            return this;
        }

        public final void setExpectedCompletionDate(Instant expectedCompletionDate) {
            this.expectedCompletionDate = expectedCompletionDate;
        }

        public final Instant getStartBy() {
            return this.startBy;
        }

        @Override
        public final Builder startBy(Instant startBy) {
            this.startBy = startBy;
            return this;
        }

        public final void setStartBy(Instant startBy) {
            this.startBy = startBy;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        public BackupJob build() {
            return new BackupJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupJob> {
        public Builder backupJobId(String var1);

        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder resourceArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder state(String var1);

        public Builder state(BackupJobState var1);

        public Builder statusMessage(String var1);

        public Builder percentDone(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder expectedCompletionDate(Instant var1);

        public Builder startBy(Instant var1);

        public Builder resourceType(String var1);

        public Builder bytesTransferred(Long var1);
    }
}

