/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which
 * specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different
 * selection of AWS resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupPlanInput implements SdkPojo, Serializable, ToCopyableBuilder<BackupPlanInput.Builder, BackupPlanInput> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupPlanInput::backupPlanName)).setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<List<BackupRuleInput>> RULES_FIELD = SdkField
            .<List<BackupRuleInput>> builder(MarshallingType.LIST)
            .getter(getter(BackupPlanInput::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupRuleInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupRuleInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD,
            RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPlanName;

    private final List<BackupRuleInput> rules;

    private BackupPlanInput(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The optional display name of a backup plan.
     * </p>
     * 
     * @return The optional display name of a backup plan.
     */
    public String backupPlanName() {
        return backupPlanName;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a
     * selection of resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
     *         back up a selection of resources.
     */
    public List<BackupRuleInput> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlanInput)) {
            return false;
        }
        BackupPlanInput other = (BackupPlanInput) obj;
        return Objects.equals(backupPlanName(), other.backupPlanName()) && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BackupPlanInput").add("BackupPlanName", backupPlanName()).add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlanInput, T> g) {
        return obj -> g.apply((BackupPlanInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupPlanInput> {
        /**
         * <p>
         * The optional display name of a backup plan.
         * </p>
         * 
         * @param backupPlanName
         *        The optional display name of a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<BackupRuleInput> rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(BackupRuleInput... rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupRuleInput>.Builder} avoiding the need
         * to create one manually via {@link List<BackupRuleInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupRuleInput>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<BackupRuleInput>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<BackupRuleInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<BackupRuleInput>)
         */
        Builder rules(Consumer<BackupRuleInput.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanName;

        private List<BackupRuleInput> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlanInput model) {
            backupPlanName(model.backupPlanName);
            rules(model.rules);
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        public final Collection<BackupRuleInput.Builder> getRules() {
            return rules != null ? rules.stream().map(BackupRuleInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<BackupRuleInput> rules) {
            this.rules = BackupRulesInputCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(BackupRuleInput... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<BackupRuleInput.Builder>... rules) {
            rules(Stream.of(rules).map(c -> BackupRuleInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<BackupRuleInput.BuilderImpl> rules) {
            this.rules = BackupRulesInputCopier.copyFromBuilder(rules);
        }

        @Override
        public BackupPlanInput build() {
            return new BackupPlanInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
