/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array of <code>Transition</code> objects specifying how long in days before a recovery point transitions
 * to cold storage or is deleted.
 * </p>
 * <p>
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the
 * console, the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting.
 * The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
 * </p>
 * <p>
 * Only Amazon EFS file system backups can be transitioned to cold storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Lifecycle implements SdkPojo, Serializable, ToCopyableBuilder<Lifecycle.Builder, Lifecycle> {
    private static final SdkField<Long> MOVE_TO_COLD_STORAGE_AFTER_DAYS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MoveToColdStorageAfterDays")
            .getter(getter(Lifecycle::moveToColdStorageAfterDays))
            .setter(setter(Builder::moveToColdStorageAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoveToColdStorageAfterDays").build())
            .build();

    private static final SdkField<Long> DELETE_AFTER_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DeleteAfterDays").getter(getter(Lifecycle::deleteAfterDays)).setter(setter(Builder::deleteAfterDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAfterDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MOVE_TO_COLD_STORAGE_AFTER_DAYS_FIELD, DELETE_AFTER_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long moveToColdStorageAfterDays;

    private final Long deleteAfterDays;

    private Lifecycle(BuilderImpl builder) {
        this.moveToColdStorageAfterDays = builder.moveToColdStorageAfterDays;
        this.deleteAfterDays = builder.deleteAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is moved to cold storage.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    public final Long moveToColdStorageAfterDays() {
        return moveToColdStorageAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus
     * <code>MoveToColdStorageAfterDays</code>.
     * </p>
     * 
     * @return Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
     *         days plus <code>MoveToColdStorageAfterDays</code>.
     */
    public final Long deleteAfterDays() {
        return deleteAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moveToColdStorageAfterDays());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAfterDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lifecycle)) {
            return false;
        }
        Lifecycle other = (Lifecycle) obj;
        return Objects.equals(moveToColdStorageAfterDays(), other.moveToColdStorageAfterDays())
                && Objects.equals(deleteAfterDays(), other.deleteAfterDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Lifecycle").add("MoveToColdStorageAfterDays", moveToColdStorageAfterDays())
                .add("DeleteAfterDays", deleteAfterDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MoveToColdStorageAfterDays":
            return Optional.ofNullable(clazz.cast(moveToColdStorageAfterDays()));
        case "DeleteAfterDays":
            return Optional.ofNullable(clazz.cast(deleteAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Lifecycle, T> g) {
        return obj -> g.apply((Lifecycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Lifecycle> {
        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         * </p>
         * 
         * @param moveToColdStorageAfterDays
         *        Specifies the number of days after creation that a recovery point is moved to cold storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moveToColdStorageAfterDays(Long moveToColdStorageAfterDays);

        /**
         * <p>
         * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days
         * plus <code>MoveToColdStorageAfterDays</code>.
         * </p>
         * 
         * @param deleteAfterDays
         *        Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90
         *        days plus <code>MoveToColdStorageAfterDays</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAfterDays(Long deleteAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private Long moveToColdStorageAfterDays;

        private Long deleteAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(Lifecycle model) {
            moveToColdStorageAfterDays(model.moveToColdStorageAfterDays);
            deleteAfterDays(model.deleteAfterDays);
        }

        public final Long getMoveToColdStorageAfterDays() {
            return moveToColdStorageAfterDays;
        }

        @Override
        public final Builder moveToColdStorageAfterDays(Long moveToColdStorageAfterDays) {
            this.moveToColdStorageAfterDays = moveToColdStorageAfterDays;
            return this;
        }

        public final void setMoveToColdStorageAfterDays(Long moveToColdStorageAfterDays) {
            this.moveToColdStorageAfterDays = moveToColdStorageAfterDays;
        }

        public final Long getDeleteAfterDays() {
            return deleteAfterDays;
        }

        @Override
        public final Builder deleteAfterDays(Long deleteAfterDays) {
            this.deleteAfterDays = deleteAfterDays;
            return this;
        }

        public final void setDeleteAfterDays(Long deleteAfterDays) {
            this.deleteAfterDays = deleteAfterDays;
        }

        @Override
        public Lifecycle build() {
            return new Lifecycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
