/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRegionSettingsResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeRegionSettingsResponse.Builder, DescribeRegionSettingsResponse> {
    private static final SdkField<Map<String, Boolean>> RESOURCE_TYPE_OPT_IN_PREFERENCE_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .memberName("ResourceTypeOptInPreference")
            .getter(getter(DescribeRegionSettingsResponse::resourceTypeOptInPreference))
            .setter(setter(Builder::resourceTypeOptInPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeOptInPreference")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Boolean>> RESOURCE_TYPE_MANAGEMENT_PREFERENCE_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .memberName("ResourceTypeManagementPreference")
            .getter(getter(DescribeRegionSettingsResponse::resourceTypeManagementPreference))
            .setter(setter(Builder::resourceTypeManagementPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeManagementPreference")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_TYPE_OPT_IN_PREFERENCE_FIELD, RESOURCE_TYPE_MANAGEMENT_PREFERENCE_FIELD));

    private final Map<String, Boolean> resourceTypeOptInPreference;

    private final Map<String, Boolean> resourceTypeManagementPreference;

    private DescribeRegionSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTypeOptInPreference = builder.resourceTypeOptInPreference;
        this.resourceTypeManagementPreference = builder.resourceTypeManagementPreference;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeOptInPreference property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceTypeOptInPreference() {
        return resourceTypeOptInPreference != null && !(resourceTypeOptInPreference instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns a list of all services along with the opt-in preferences in the Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeOptInPreference} method.
     * </p>
     * 
     * @return Returns a list of all services along with the opt-in preferences in the Region.
     */
    public final Map<String, Boolean> resourceTypeOptInPreference() {
        return resourceTypeOptInPreference;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeManagementPreference
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasResourceTypeManagementPreference() {
        return resourceTypeManagementPreference != null && !(resourceTypeManagementPreference instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Returns whether a DynamoDB recovery point was taken using <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced
     * DynamoDB backup features</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeManagementPreference}
     * method.
     * </p>
     * 
     * @return Returns whether a DynamoDB recovery point was taken using <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced
     *         DynamoDB backup features</a>.
     */
    public final Map<String, Boolean> resourceTypeManagementPreference() {
        return resourceTypeManagementPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeOptInPreference() ? resourceTypeOptInPreference() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasResourceTypeManagementPreference() ? resourceTypeManagementPreference() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionSettingsResponse)) {
            return false;
        }
        DescribeRegionSettingsResponse other = (DescribeRegionSettingsResponse) obj;
        return hasResourceTypeOptInPreference() == other.hasResourceTypeOptInPreference()
                && Objects.equals(resourceTypeOptInPreference(), other.resourceTypeOptInPreference())
                && hasResourceTypeManagementPreference() == other.hasResourceTypeManagementPreference()
                && Objects.equals(resourceTypeManagementPreference(), other.resourceTypeManagementPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeRegionSettingsResponse")
                .add("ResourceTypeOptInPreference", hasResourceTypeOptInPreference() ? resourceTypeOptInPreference() : null)
                .add("ResourceTypeManagementPreference",
                        hasResourceTypeManagementPreference() ? resourceTypeManagementPreference() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTypeOptInPreference":
            return Optional.ofNullable(clazz.cast(resourceTypeOptInPreference()));
        case "ResourceTypeManagementPreference":
            return Optional.ofNullable(clazz.cast(resourceTypeManagementPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRegionSettingsResponse, T> g) {
        return obj -> g.apply((DescribeRegionSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRegionSettingsResponse> {
        /**
         * <p>
         * Returns a list of all services along with the opt-in preferences in the Region.
         * </p>
         * 
         * @param resourceTypeOptInPreference
         *        Returns a list of all services along with the opt-in preferences in the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeOptInPreference(Map<String, Boolean> resourceTypeOptInPreference);

        /**
         * <p>
         * Returns whether a DynamoDB recovery point was taken using <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's advanced
         * DynamoDB backup features</a>.
         * </p>
         * 
         * @param resourceTypeManagementPreference
         *        Returns whether a DynamoDB recovery point was taken using <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html"> Backup's
         *        advanced DynamoDB backup features</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeManagementPreference(Map<String, Boolean> resourceTypeManagementPreference);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Map<String, Boolean> resourceTypeOptInPreference = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Boolean> resourceTypeManagementPreference = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRegionSettingsResponse model) {
            super(model);
            resourceTypeOptInPreference(model.resourceTypeOptInPreference);
            resourceTypeManagementPreference(model.resourceTypeManagementPreference);
        }

        public final Map<String, Boolean> getResourceTypeOptInPreference() {
            if (resourceTypeOptInPreference instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTypeOptInPreference;
        }

        public final void setResourceTypeOptInPreference(Map<String, Boolean> resourceTypeOptInPreference) {
            this.resourceTypeOptInPreference = ResourceTypeOptInPreferenceCopier.copy(resourceTypeOptInPreference);
        }

        @Override
        @Transient
        public final Builder resourceTypeOptInPreference(Map<String, Boolean> resourceTypeOptInPreference) {
            this.resourceTypeOptInPreference = ResourceTypeOptInPreferenceCopier.copy(resourceTypeOptInPreference);
            return this;
        }

        public final Map<String, Boolean> getResourceTypeManagementPreference() {
            if (resourceTypeManagementPreference instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTypeManagementPreference;
        }

        public final void setResourceTypeManagementPreference(Map<String, Boolean> resourceTypeManagementPreference) {
            this.resourceTypeManagementPreference = ResourceTypeManagementPreferenceCopier.copy(resourceTypeManagementPreference);
        }

        @Override
        @Transient
        public final Builder resourceTypeManagementPreference(Map<String, Boolean> resourceTypeManagementPreference) {
            this.resourceTypeManagementPreference = ResourceTypeManagementPreferenceCopier.copy(resourceTypeManagementPreference);
            return this;
        }

        @Override
        public DescribeRegionSettingsResponse build() {
            return new DescribeRegionSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
