/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupVaultRequest extends BackupRequest implements
        ToCopyableBuilder<CreateBackupVaultRequest.Builder, CreateBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(CreateBackupVaultRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<Map<String, String>> BACKUP_VAULT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("BackupVaultTags")
            .getter(getter(CreateBackupVaultRequest::backupVaultTags))
            .setter(setter(Builder::backupVaultTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(CreateBackupVaultRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateBackupVaultRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            BACKUP_VAULT_TAGS_FIELD, ENCRYPTION_KEY_ARN_FIELD, CREATOR_REQUEST_ID_FIELD));

    private final String backupVaultName;

    private final Map<String, String> backupVaultTags;

    private final String encryptionKeyArn;

    private final String creatorRequestId;

    private CreateBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultTags = builder.backupVaultTags;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the AWS Region where they are created. They consist of letters, numbers,
     * and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the AWS Region where they are created. They consist of
     *         letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * Returns true if the BackupVaultTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBackupVaultTags() {
        return backupVaultTags != null && !(backupVaultTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackupVaultTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata that you can assign to help organize the resources that you create. Each tag is a key-value
     *         pair.
     */
    public final Map<String, String> backupVaultTags() {
        return backupVaultTags;
    }

    /**
     * <p>
     * The server-side encryption key that is used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key that is used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running
     * the operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request and allows failed requests to be retried without the risk of
     *         running the operation twice.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupVaultTags() ? backupVaultTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupVaultRequest)) {
            return false;
        }
        CreateBackupVaultRequest other = (CreateBackupVaultRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && hasBackupVaultTags() == other.hasBackupVaultTags()
                && Objects.equals(backupVaultTags(), other.backupVaultTags())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackupVaultRequest").add("BackupVaultName", backupVaultName())
                .add("BackupVaultTags", backupVaultTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EncryptionKeyArn", encryptionKeyArn()).add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultTags":
            return Optional.ofNullable(clazz.cast(backupVaultTags()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupVaultRequest, T> g) {
        return obj -> g.apply((CreateBackupVaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupVaultRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the AWS Region where they are created. They consist of letters,
         * numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the AWS Region where they are created. They consist
         *        of letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.
         * </p>
         * 
         * @param backupVaultTags
         *        Metadata that you can assign to help organize the resources that you create. Each tag is a key-value
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultTags(Map<String, String> backupVaultTags);

        /**
         * <p>
         * The server-side encryption key that is used to protect your backups; for example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The server-side encryption key that is used to protect your backups; for example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * A unique string that identifies the request and allows failed requests to be retried without the risk of
         * running the operation twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and allows failed requests to be retried without the risk
         *        of running the operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private Map<String, String> backupVaultTags = DefaultSdkAutoConstructMap.getInstance();

        private String encryptionKeyArn;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupVaultRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            backupVaultTags(model.backupVaultTags);
            encryptionKeyArn(model.encryptionKeyArn);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        @Transient
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Map<String, String> getBackupVaultTags() {
            if (backupVaultTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return backupVaultTags;
        }

        public final void setBackupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
        }

        @Override
        @Transient
        public final Builder backupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        @Transient
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        @Transient
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupVaultRequest build() {
            return new CreateBackupVaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
