/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an optional backup plan display name and an array of <code>BackupRule</code> objects, each of which
 * specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different
 * selection of Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupPlan implements SdkPojo, Serializable, ToCopyableBuilder<BackupPlan.Builder, BackupPlan> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanName").getter(getter(BackupPlan::backupPlanName)).setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<List<BackupRule>> RULES_FIELD = SdkField
            .<List<BackupRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(BackupPlan::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField
            .<List<AdvancedBackupSetting>> builder(MarshallingType.LIST)
            .memberName("AdvancedBackupSettings")
            .getter(getter(BackupPlan::advancedBackupSettings))
            .setter(setter(Builder::advancedBackupSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedBackupSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedBackupSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD,
            RULES_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPlanName;

    private final List<BackupRule> rules;

    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private BackupPlan(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    /**
     * <p>
     * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String backupPlanName() {
        return backupPlanName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a
     * selection of resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
     *         back up a selection of resources.
     */
    public final List<BackupRule> rules() {
        return rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedBackupSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedBackupSettings() {
        return advancedBackupSettings != null && !(advancedBackupSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of <code>BackupOptions</code> for each resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedBackupSettings} method.
     * </p>
     * 
     * @return Contains a list of <code>BackupOptions</code> for each resource type.
     */
    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return advancedBackupSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedBackupSettings() ? advancedBackupSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlan)) {
            return false;
        }
        BackupPlan other = (BackupPlan) obj;
        return Objects.equals(backupPlanName(), other.backupPlanName()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings()
                && Objects.equals(advancedBackupSettings(), other.advancedBackupSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupPlan").add("BackupPlanName", backupPlanName()).add("Rules", hasRules() ? rules() : null)
                .add("AdvancedBackupSettings", hasAdvancedBackupSettings() ? advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "AdvancedBackupSettings":
            return Optional.ofNullable(clazz.cast(advancedBackupSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlan, T> g) {
        return obj -> g.apply((BackupPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupPlan> {
        /**
         * <p>
         * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param backupPlanName
         *        The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<BackupRule> rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param rules
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(BackupRule... rules);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupRule>.Builder} avoiding the need to
         * create one manually via {@link List<BackupRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<BackupRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<BackupRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<BackupRule>)
         */
        Builder rules(Consumer<BackupRule.Builder>... rules);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdvancedBackupSetting>.Builder} avoiding
         * the need to create one manually via {@link List<AdvancedBackupSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdvancedBackupSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedBackupSettings(List<AdvancedBackupSetting>)}.
         * 
         * @param advancedBackupSettings
         *        a consumer that will call methods on {@link List<AdvancedBackupSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedBackupSettings(List<AdvancedBackupSetting>)
         */
        Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanName;

        private List<BackupRule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlan model) {
            backupPlanName(model.backupPlanName);
            rules(model.rules);
            advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        @Transient
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final List<BackupRule.Builder> getRules() {
            List<BackupRule.Builder> result = BackupRulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<BackupRule.BuilderImpl> rules) {
            this.rules = BackupRulesCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<BackupRule> rules) {
            this.rules = BackupRulesCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(BackupRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<BackupRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> BackupRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        @Transient
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings) {
            advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings) {
            advancedBackupSettings(Stream.of(advancedBackupSettings)
                    .map(c -> AdvancedBackupSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BackupPlan build() {
            return new BackupPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
