/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information from your report job about your report destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportDestination.Builder, ReportDestination> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(ReportDestination::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<List<String>> S3_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("S3Keys")
            .getter(getter(ReportDestination::s3Keys))
            .setter(setter(Builder::s3Keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD,
            S3_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3BucketName;

    private final List<String> s3Keys;

    private ReportDestination(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3Keys = builder.s3Keys;
    }

    /**
     * <p>
     * The unique name of the Amazon S3 bucket that receives your reports.
     * </p>
     * 
     * @return The unique name of the Amazon S3 bucket that receives your reports.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Keys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasS3Keys() {
        return s3Keys != null && !(s3Keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The object key that uniquely identifies your reports in your S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Keys} method.
     * </p>
     * 
     * @return The object key that uniquely identifies your reports in your S3 bucket.
     */
    public final List<String> s3Keys() {
        return s3Keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Keys() ? s3Keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestination)) {
            return false;
        }
        ReportDestination other = (ReportDestination) obj;
        return Objects.equals(s3BucketName(), other.s3BucketName()) && hasS3Keys() == other.hasS3Keys()
                && Objects.equals(s3Keys(), other.s3Keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportDestination").add("S3BucketName", s3BucketName())
                .add("S3Keys", hasS3Keys() ? s3Keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3Keys":
            return Optional.ofNullable(clazz.cast(s3Keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDestination, T> g) {
        return obj -> g.apply((ReportDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportDestination> {
        /**
         * <p>
         * The unique name of the Amazon S3 bucket that receives your reports.
         * </p>
         * 
         * @param s3BucketName
         *        The unique name of the Amazon S3 bucket that receives your reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The object key that uniquely identifies your reports in your S3 bucket.
         * </p>
         * 
         * @param s3Keys
         *        The object key that uniquely identifies your reports in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Keys(Collection<String> s3Keys);

        /**
         * <p>
         * The object key that uniquely identifies your reports in your S3 bucket.
         * </p>
         * 
         * @param s3Keys
         *        The object key that uniquely identifies your reports in your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Keys(String... s3Keys);
    }

    static final class BuilderImpl implements Builder {
        private String s3BucketName;

        private List<String> s3Keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDestination model) {
            s3BucketName(model.s3BucketName);
            s3Keys(model.s3Keys);
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Collection<String> getS3Keys() {
            if (s3Keys instanceof SdkAutoConstructList) {
                return null;
            }
            return s3Keys;
        }

        public final void setS3Keys(Collection<String> s3Keys) {
            this.s3Keys = _stringListCopier.copy(s3Keys);
        }

        @Override
        @Transient
        public final Builder s3Keys(Collection<String> s3Keys) {
            this.s3Keys = _stringListCopier.copy(s3Keys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder s3Keys(String... s3Keys) {
            s3Keys(Arrays.asList(s3Keys));
            return this;
        }

        @Override
        public ReportDestination build() {
            return new ReportDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
