/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupJobsResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupJobsResponse.Builder, ListBackupJobsResponse> {
    private static final SdkField<List<BackupJob>> BACKUP_JOBS_FIELD = SdkField
            .<List<BackupJob>> builder(MarshallingType.LIST)
            .memberName("BackupJobs")
            .getter(getter(ListBackupJobsResponse::backupJobs))
            .setter(setter(Builder::backupJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BackupJob> backupJobs;

    private final String nextToken;

    private ListBackupJobsResponse(BuilderImpl builder) {
        super(builder);
        this.backupJobs = builder.backupJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBackupJobs() {
        return backupJobs != null && !(backupJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures containing metadata about your backup jobs returned in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupJobs} method.
     * </p>
     * 
     * @return An array of structures containing metadata about your backup jobs returned in JSON format.
     */
    public final List<BackupJob> backupJobs() {
        return backupJobs;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupJobs() ? backupJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupJobsResponse)) {
            return false;
        }
        ListBackupJobsResponse other = (ListBackupJobsResponse) obj;
        return hasBackupJobs() == other.hasBackupJobs() && Objects.equals(backupJobs(), other.backupJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupJobsResponse").add("BackupJobs", hasBackupJobs() ? backupJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobs":
            return Optional.ofNullable(clazz.cast(backupJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupJobsResponse, T> g) {
        return obj -> g.apply((ListBackupJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupJobsResponse> {
        /**
         * <p>
         * An array of structures containing metadata about your backup jobs returned in JSON format.
         * </p>
         * 
         * @param backupJobs
         *        An array of structures containing metadata about your backup jobs returned in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobs(Collection<BackupJob> backupJobs);

        /**
         * <p>
         * An array of structures containing metadata about your backup jobs returned in JSON format.
         * </p>
         * 
         * @param backupJobs
         *        An array of structures containing metadata about your backup jobs returned in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobs(BackupJob... backupJobs);

        /**
         * <p>
         * An array of structures containing metadata about your backup jobs returned in JSON format.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupJob>.Builder} avoiding the need to
         * create one manually via {@link List<BackupJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupJob>.Builder#build()} is called immediately and its
         * result is passed to {@link #backupJobs(List<BackupJob>)}.
         * 
         * @param backupJobs
         *        a consumer that will call methods on {@link List<BackupJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupJobs(List<BackupJob>)
         */
        Builder backupJobs(Consumer<BackupJob.Builder>... backupJobs);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<BackupJob> backupJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupJobsResponse model) {
            super(model);
            backupJobs(model.backupJobs);
            nextToken(model.nextToken);
        }

        public final List<BackupJob.Builder> getBackupJobs() {
            List<BackupJob.Builder> result = BackupJobsListCopier.copyToBuilder(this.backupJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupJobs(Collection<BackupJob.BuilderImpl> backupJobs) {
            this.backupJobs = BackupJobsListCopier.copyFromBuilder(backupJobs);
        }

        @Override
        @Transient
        public final Builder backupJobs(Collection<BackupJob> backupJobs) {
            this.backupJobs = BackupJobsListCopier.copy(backupJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupJobs(BackupJob... backupJobs) {
            backupJobs(Arrays.asList(backupJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupJobs(Consumer<BackupJob.Builder>... backupJobs) {
            backupJobs(Stream.of(backupJobs).map(c -> BackupJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBackupJobsResponse build() {
            return new ListBackupJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
