/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupVaultsResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupVaultsResponse.Builder, ListBackupVaultsResponse> {
    private static final SdkField<List<BackupVaultListMember>> BACKUP_VAULT_LIST_FIELD = SdkField
            .<List<BackupVaultListMember>> builder(MarshallingType.LIST)
            .memberName("BackupVaultList")
            .getter(getter(ListBackupVaultsResponse::backupVaultList))
            .setter(setter(Builder::backupVaultList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupVaultListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupVaultListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupVaultsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BackupVaultListMember> backupVaultList;

    private final String nextToken;

    private ListBackupVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultList = builder.backupVaultList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BackupVaultList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBackupVaultList() {
        return backupVaultList != null && !(backupVaultList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN), display
     * name, creation date, number of saved recovery points, and encryption information if the resources saved in the
     * backup vault are encrypted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackupVaultList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
     *         display name, creation date, number of saved recovery points, and encryption information if the resources
     *         saved in the backup vault are encrypted.
     */
    public final List<BackupVaultListMember> backupVaultList() {
        return backupVaultList;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupVaultList() ? backupVaultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupVaultsResponse)) {
            return false;
        }
        ListBackupVaultsResponse other = (ListBackupVaultsResponse) obj;
        return hasBackupVaultList() == other.hasBackupVaultList() && Objects.equals(backupVaultList(), other.backupVaultList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupVaultsResponse")
                .add("BackupVaultList", hasBackupVaultList() ? backupVaultList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultList":
            return Optional.ofNullable(clazz.cast(backupVaultList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupVaultsResponse, T> g) {
        return obj -> g.apply((ListBackupVaultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupVaultsResponse> {
        /**
         * <p>
         * An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
         * display name, creation date, number of saved recovery points, and encryption information if the resources
         * saved in the backup vault are encrypted.
         * </p>
         * 
         * @param backupVaultList
         *        An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
         *        display name, creation date, number of saved recovery points, and encryption information if the
         *        resources saved in the backup vault are encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultList(Collection<BackupVaultListMember> backupVaultList);

        /**
         * <p>
         * An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
         * display name, creation date, number of saved recovery points, and encryption information if the resources
         * saved in the backup vault are encrypted.
         * </p>
         * 
         * @param backupVaultList
         *        An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
         *        display name, creation date, number of saved recovery points, and encryption information if the
         *        resources saved in the backup vault are encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultList(BackupVaultListMember... backupVaultList);

        /**
         * <p>
         * An array of backup vault list members containing vault metadata, including Amazon Resource Name (ARN),
         * display name, creation date, number of saved recovery points, and encryption information if the resources
         * saved in the backup vault are encrypted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupVaultListMember>.Builder} avoiding
         * the need to create one manually via {@link List<BackupVaultListMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupVaultListMember>.Builder#build()} is called
         * immediately and its result is passed to {@link #backupVaultList(List<BackupVaultListMember>)}.
         * 
         * @param backupVaultList
         *        a consumer that will call methods on {@link List<BackupVaultListMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupVaultList(List<BackupVaultListMember>)
         */
        Builder backupVaultList(Consumer<BackupVaultListMember.Builder>... backupVaultList);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<BackupVaultListMember> backupVaultList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupVaultsResponse model) {
            super(model);
            backupVaultList(model.backupVaultList);
            nextToken(model.nextToken);
        }

        public final List<BackupVaultListMember.Builder> getBackupVaultList() {
            List<BackupVaultListMember.Builder> result = BackupVaultListCopier.copyToBuilder(this.backupVaultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupVaultList(Collection<BackupVaultListMember.BuilderImpl> backupVaultList) {
            this.backupVaultList = BackupVaultListCopier.copyFromBuilder(backupVaultList);
        }

        @Override
        @Transient
        public final Builder backupVaultList(Collection<BackupVaultListMember> backupVaultList) {
            this.backupVaultList = BackupVaultListCopier.copy(backupVaultList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupVaultList(BackupVaultListMember... backupVaultList) {
            backupVaultList(Arrays.asList(backupVaultList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupVaultList(Consumer<BackupVaultListMember.Builder>... backupVaultList) {
            backupVaultList(Stream.of(backupVaultList).map(c -> BackupVaultListMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBackupVaultsResponse build() {
            return new ListBackupVaultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
