/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReportJobRequest extends BackupRequest implements
        ToCopyableBuilder<StartReportJobRequest.Builder, StartReportJobRequest> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanName").getter(getter(StartReportJobRequest::reportPlanName))
            .setter(setter(Builder::reportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("reportPlanName").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(StartReportJobRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD,
            IDEMPOTENCY_TOKEN_FIELD));

    private final String reportPlanName;

    private final String idempotencyToken;

    private StartReportJobRequest(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The unique name of a report plan.
     * </p>
     * 
     * @return The unique name of a report plan.
     */
    public final String reportPlanName() {
        return reportPlanName;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token results in a
     * success message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token results
     *         in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReportJobRequest)) {
            return false;
        }
        StartReportJobRequest other = (StartReportJobRequest) obj;
        return Objects.equals(reportPlanName(), other.reportPlanName())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReportJobRequest").add("ReportPlanName", reportPlanName())
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlanName":
            return Optional.ofNullable(clazz.cast(reportPlanName()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReportJobRequest, T> g) {
        return obj -> g.apply((StartReportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartReportJobRequest> {
        /**
         * <p>
         * The unique name of a report plan.
         * </p>
         * 
         * @param reportPlanName
         *        The unique name of a report plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanName(String reportPlanName);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token results in a
         * success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>StartReportJobInput</code>. Retrying a successful request with the same idempotency token
         *        results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String reportPlanName;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReportJobRequest model) {
            super(model);
            reportPlanName(model.reportPlanName);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getReportPlanName() {
            return reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        @Transient
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReportJobRequest build() {
            return new StartReportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
