/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains an array of triplets made up of a condition type (such as <code>StringEquals</code>), a key, and a value.
 * Used to filter resources using their tags and assign them to a backup plan. Case sensitive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<String> CONDITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionType").getter(getter(Condition::conditionTypeAsString)).setter(setter(Builder::conditionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionType").build()).build();

    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionKey").getter(getter(Condition::conditionKey)).setter(setter(Builder::conditionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionKey").build()).build();

    private static final SdkField<String> CONDITION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionValue").getter(getter(Condition::conditionValue)).setter(setter(Builder::conditionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_TYPE_FIELD,
            CONDITION_KEY_FIELD, CONDITION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conditionType;

    private final String conditionKey;

    private final String conditionValue;

    private Condition(BuilderImpl builder) {
        this.conditionType = builder.conditionType;
        this.conditionKey = builder.conditionKey;
        this.conditionValue = builder.conditionValue;
    }

    /**
     * <p>
     * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only supports
     * <code>StringEquals</code>. For more flexible assignment options, including <code>StringLike</code> and the
     * ability to exclude resources from your backup plan, use <code>Conditions</code> (with an "s" on the end) for your
     * <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
     * <code>BackupSelection</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link ConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
     *         supports <code>StringEquals</code>. For more flexible assignment options, including
     *         <code>StringLike</code> and the ability to exclude resources from your backup plan, use
     *         <code>Conditions</code> (with an "s" on the end) for your <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
     *         <code>BackupSelection</code> </a>.
     * @see ConditionType
     */
    public final ConditionType conditionType() {
        return ConditionType.fromValue(conditionType);
    }

    /**
     * <p>
     * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only supports
     * <code>StringEquals</code>. For more flexible assignment options, including <code>StringLike</code> and the
     * ability to exclude resources from your backup plan, use <code>Conditions</code> (with an "s" on the end) for your
     * <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
     * <code>BackupSelection</code> </a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link ConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
     *         supports <code>StringEquals</code>. For more flexible assignment options, including
     *         <code>StringLike</code> and the ability to exclude resources from your backup plan, use
     *         <code>Conditions</code> (with an "s" on the end) for your <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
     *         <code>BackupSelection</code> </a>.
     * @see ConditionType
     */
    public final String conditionTypeAsString() {
        return conditionType;
    }

    /**
     * <p>
     * The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>, <code>Department</code>
     * is the key.
     * </p>
     * 
     * @return The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
     *         <code>Department</code> is the key.
     */
    public final String conditionKey() {
        return conditionKey;
    }

    /**
     * <p>
     * The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
     * <code>Accounting</code> is the value.
     * </p>
     * 
     * @return The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
     *         <code>Accounting</code> is the value.
     */
    public final String conditionValue() {
        return conditionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(conditionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(conditionTypeAsString(), other.conditionTypeAsString())
                && Objects.equals(conditionKey(), other.conditionKey())
                && Objects.equals(conditionValue(), other.conditionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("ConditionType", conditionTypeAsString()).add("ConditionKey", conditionKey())
                .add("ConditionValue", conditionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionType":
            return Optional.ofNullable(clazz.cast(conditionTypeAsString()));
        case "ConditionKey":
            return Optional.ofNullable(clazz.cast(conditionKey()));
        case "ConditionValue":
            return Optional.ofNullable(clazz.cast(conditionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
         * supports <code>StringEquals</code>. For more flexible assignment options, including <code>StringLike</code>
         * and the ability to exclude resources from your backup plan, use <code>Conditions</code> (with an "s" on the
         * end) for your <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
         * <code>BackupSelection</code> </a>.
         * </p>
         * 
         * @param conditionType
         *        An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
         *        supports <code>StringEquals</code>. For more flexible assignment options, including
         *        <code>StringLike</code> and the ability to exclude resources from your backup plan, use
         *        <code>Conditions</code> (with an "s" on the end) for your <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
         *        <code>BackupSelection</code> </a>.
         * @see ConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionType
         */
        Builder conditionType(String conditionType);

        /**
         * <p>
         * An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
         * supports <code>StringEquals</code>. For more flexible assignment options, including <code>StringLike</code>
         * and the ability to exclude resources from your backup plan, use <code>Conditions</code> (with an "s" on the
         * end) for your <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
         * <code>BackupSelection</code> </a>.
         * </p>
         * 
         * @param conditionType
         *        An operation applied to a key-value pair used to assign resources to your backup plan. Condition only
         *        supports <code>StringEquals</code>. For more flexible assignment options, including
         *        <code>StringLike</code> and the ability to exclude resources from your backup plan, use
         *        <code>Conditions</code> (with an "s" on the end) for your <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html">
         *        <code>BackupSelection</code> </a>.
         * @see ConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionType
         */
        Builder conditionType(ConditionType conditionType);

        /**
         * <p>
         * The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
         * <code>Department</code> is the key.
         * </p>
         * 
         * @param conditionKey
         *        The key in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
         *        <code>Department</code> is the key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionKey(String conditionKey);

        /**
         * <p>
         * The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
         * <code>Accounting</code> is the value.
         * </p>
         * 
         * @param conditionValue
         *        The value in a key-value pair. For example, in the tag <code>Department: Accounting</code>,
         *        <code>Accounting</code> is the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionValue(String conditionValue);
    }

    static final class BuilderImpl implements Builder {
        private String conditionType;

        private String conditionKey;

        private String conditionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            conditionType(model.conditionType);
            conditionKey(model.conditionKey);
            conditionValue(model.conditionValue);
        }

        public final String getConditionType() {
            return conditionType;
        }

        public final void setConditionType(String conditionType) {
            this.conditionType = conditionType;
        }

        @Override
        @Transient
        public final Builder conditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        @Override
        @Transient
        public final Builder conditionType(ConditionType conditionType) {
            this.conditionType(conditionType == null ? null : conditionType.toString());
            return this;
        }

        public final String getConditionKey() {
            return conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        @Transient
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final String getConditionValue() {
            return conditionValue;
        }

        public final void setConditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
        }

        @Override
        @Transient
        public final Builder conditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
