/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReportJobResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeReportJobResponse.Builder, DescribeReportJobResponse> {
    private static final SdkField<ReportJob> REPORT_JOB_FIELD = SdkField.<ReportJob> builder(MarshallingType.SDK_POJO)
            .memberName("ReportJob").getter(getter(DescribeReportJobResponse::reportJob)).setter(setter(Builder::reportJob))
            .constructor(ReportJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOB_FIELD));

    private final ReportJob reportJob;

    private DescribeReportJobResponse(BuilderImpl builder) {
        super(builder);
        this.reportJob = builder.reportJob;
    }

    /**
     * <p>
     * A list of information about a report job, including its completion and creation times, report destination, unique
     * report job ID, Amazon Resource Name (ARN), report template, status, and status message.
     * </p>
     * 
     * @return A list of information about a report job, including its completion and creation times, report
     *         destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status
     *         message.
     */
    public final ReportJob reportJob() {
        return reportJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportJobResponse)) {
            return false;
        }
        DescribeReportJobResponse other = (DescribeReportJobResponse) obj;
        return Objects.equals(reportJob(), other.reportJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReportJobResponse").add("ReportJob", reportJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportJob":
            return Optional.ofNullable(clazz.cast(reportJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportJobResponse, T> g) {
        return obj -> g.apply((DescribeReportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReportJobResponse> {
        /**
         * <p>
         * A list of information about a report job, including its completion and creation times, report destination,
         * unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.
         * </p>
         * 
         * @param reportJob
         *        A list of information about a report job, including its completion and creation times, report
         *        destination, unique report job ID, Amazon Resource Name (ARN), report template, status, and status
         *        message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportJob(ReportJob reportJob);

        /**
         * <p>
         * A list of information about a report job, including its completion and creation times, report destination,
         * unique report job ID, Amazon Resource Name (ARN), report template, status, and status message.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportJob.Builder} avoiding the need to
         * create one manually via {@link ReportJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportJob.Builder#build()} is called immediately and its result
         * is passed to {@link #reportJob(ReportJob)}.
         * 
         * @param reportJob
         *        a consumer that will call methods on {@link ReportJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportJob(ReportJob)
         */
        default Builder reportJob(Consumer<ReportJob.Builder> reportJob) {
            return reportJob(ReportJob.builder().applyMutation(reportJob).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private ReportJob reportJob;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportJobResponse model) {
            super(model);
            reportJob(model.reportJob);
        }

        public final ReportJob.Builder getReportJob() {
            return reportJob != null ? reportJob.toBuilder() : null;
        }

        public final void setReportJob(ReportJob.BuilderImpl reportJob) {
            this.reportJob = reportJob != null ? reportJob.build() : null;
        }

        @Override
        @Transient
        public final Builder reportJob(ReportJob reportJob) {
            this.reportJob = reportJob;
            return this;
        }

        @Override
        public DescribeReportJobResponse build() {
            return new DescribeReportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
