/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFrameworksResponse extends BackupResponse implements
        ToCopyableBuilder<ListFrameworksResponse.Builder, ListFrameworksResponse> {
    private static final SdkField<List<Framework>> FRAMEWORKS_FIELD = SdkField
            .<List<Framework>> builder(MarshallingType.LIST)
            .memberName("Frameworks")
            .getter(getter(ListFrameworksResponse::frameworks))
            .setter(setter(Builder::frameworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frameworks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Framework> builder(MarshallingType.SDK_POJO)
                                            .constructor(Framework::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFrameworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Framework> frameworks;

    private final String nextToken;

    private ListFrameworksResponse(BuilderImpl builder) {
        super(builder);
        this.frameworks = builder.frameworks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Frameworks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFrameworks() {
        return frameworks != null && !(frameworks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of frameworks with details for each framework, including the framework name, Amazon Resource Name (ARN),
     * description, number of controls, creation time, and deployment status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameworks} method.
     * </p>
     * 
     * @return A list of frameworks with details for each framework, including the framework name, Amazon Resource Name
     *         (ARN), description, number of controls, creation time, and deployment status.
     */
    public final List<Framework> frameworks() {
        return frameworks;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworks() ? frameworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFrameworksResponse)) {
            return false;
        }
        ListFrameworksResponse other = (ListFrameworksResponse) obj;
        return hasFrameworks() == other.hasFrameworks() && Objects.equals(frameworks(), other.frameworks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFrameworksResponse").add("Frameworks", hasFrameworks() ? frameworks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Frameworks":
            return Optional.ofNullable(clazz.cast(frameworks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFrameworksResponse, T> g) {
        return obj -> g.apply((ListFrameworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFrameworksResponse> {
        /**
         * <p>
         * A list of frameworks with details for each framework, including the framework name, Amazon Resource Name
         * (ARN), description, number of controls, creation time, and deployment status.
         * </p>
         * 
         * @param frameworks
         *        A list of frameworks with details for each framework, including the framework name, Amazon Resource
         *        Name (ARN), description, number of controls, creation time, and deployment status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(Collection<Framework> frameworks);

        /**
         * <p>
         * A list of frameworks with details for each framework, including the framework name, Amazon Resource Name
         * (ARN), description, number of controls, creation time, and deployment status.
         * </p>
         * 
         * @param frameworks
         *        A list of frameworks with details for each framework, including the framework name, Amazon Resource
         *        Name (ARN), description, number of controls, creation time, and deployment status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworks(Framework... frameworks);

        /**
         * <p>
         * A list of frameworks with details for each framework, including the framework name, Amazon Resource Name
         * (ARN), description, number of controls, creation time, and deployment status.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Framework>.Builder} avoiding the
         * need to create one manually via {@link List<Framework>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Framework>.Builder#build()} is called immediately and its
         * result is passed to {@link #frameworks(List<Framework>)}.
         * 
         * @param frameworks
         *        a consumer that will call methods on {@link List<Framework>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworks(List<Framework>)
         */
        Builder frameworks(Consumer<Framework.Builder>... frameworks);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<Framework> frameworks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFrameworksResponse model) {
            super(model);
            frameworks(model.frameworks);
            nextToken(model.nextToken);
        }

        public final List<Framework.Builder> getFrameworks() {
            List<Framework.Builder> result = FrameworkListCopier.copyToBuilder(this.frameworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworks(Collection<Framework.BuilderImpl> frameworks) {
            this.frameworks = FrameworkListCopier.copyFromBuilder(frameworks);
        }

        @Override
        @Transient
        public final Builder frameworks(Collection<Framework> frameworks) {
            this.frameworks = FrameworkListCopier.copy(frameworks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameworks(Framework... frameworks) {
            frameworks(Arrays.asList(frameworks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameworks(Consumer<Framework.Builder>... frameworks) {
            frameworks(Stream.of(frameworks).map(c -> Framework.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFrameworksResponse build() {
            return new ListFrameworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
