/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBackupVaultLockConfigurationRequest extends BackupRequest implements
        ToCopyableBuilder<PutBackupVaultLockConfigurationRequest.Builder, PutBackupVaultLockConfigurationRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(PutBackupVaultLockConfigurationRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<Long> MIN_RETENTION_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MinRetentionDays").getter(getter(PutBackupVaultLockConfigurationRequest::minRetentionDays))
            .setter(setter(Builder::minRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRetentionDays").build()).build();

    private static final SdkField<Long> MAX_RETENTION_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxRetentionDays").getter(getter(PutBackupVaultLockConfigurationRequest::maxRetentionDays))
            .setter(setter(Builder::maxRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetentionDays").build()).build();

    private static final SdkField<Long> CHANGEABLE_FOR_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ChangeableForDays").getter(getter(PutBackupVaultLockConfigurationRequest::changeableForDays))
            .setter(setter(Builder::changeableForDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeableForDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            MIN_RETENTION_DAYS_FIELD, MAX_RETENTION_DAYS_FIELD, CHANGEABLE_FOR_DAYS_FIELD));

    private final String backupVaultName;

    private final Long minRetentionDays;

    private final Long maxRetentionDays;

    private final Long changeableForDays;

    private PutBackupVaultLockConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.minRetentionDays = builder.minRetentionDays;
        this.maxRetentionDays = builder.maxRetentionDays;
        this.changeableForDays = builder.changeableForDays;
    }

    /**
     * <p>
     * The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
     * </p>
     * 
     * @return The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its
     * recovery points. This setting can be useful if, for example, your organization's policies require you to retain
     * certain data for at least seven years (2555 days).
     * </p>
     * <p>
     * If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
     * </p>
     * <p>
     * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention
     * period equal to or longer than the minimum retention period. If the job's retention period is shorter than that
     * minimum retention period, then the vault fails that backup or copy job, and you should either modify your
     * lifecycle settings or use a different vault. The shortest minimum retention period you can specify is 1 day.
     * Recovery points already saved in the vault prior to Vault Lock are not affected.
     * </p>
     * 
     * @return The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains
     *         its recovery points. This setting can be useful if, for example, your organization's policies require you
     *         to retain certain data for at least seven years (2555 days).</p>
     *         <p>
     *         If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
     *         </p>
     *         <p>
     *         If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a
     *         retention period equal to or longer than the minimum retention period. If the job's retention period is
     *         shorter than that minimum retention period, then the vault fails that backup or copy job, and you should
     *         either modify your lifecycle settings or use a different vault. The shortest minimum retention period you
     *         can specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are not affected.
     */
    public final Long minRetentionDays() {
        return minRetentionDays;
    }

    /**
     * <p>
     * The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its
     * recovery points. This setting can be useful if, for example, your organization's policies require you to destroy
     * certain data after retaining it for four years (1460 days).
     * </p>
     * <p>
     * If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points
     * in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention
     * period.
     * </p>
     * <p>
     * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention
     * period equal to or shorter than the maximum retention period. If the job's retention period is longer than that
     * maximum retention period, then the vault fails the backup or copy job, and you should either modify your
     * lifecycle settings or use a different vault. The longest maximum retention period you can specify is 36500 days
     * (approximately 100 years). Recovery points already saved in the vault prior to Vault Lock are not affected.
     * </p>
     * 
     * @return The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains
     *         its recovery points. This setting can be useful if, for example, your organization's policies require you
     *         to destroy certain data after retaining it for four years (1460 days).</p>
     *         <p>
     *         If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery
     *         points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum
     *         retention period.
     *         </p>
     *         <p>
     *         If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a
     *         retention period equal to or shorter than the maximum retention period. If the job's retention period is
     *         longer than that maximum retention period, then the vault fails the backup or copy job, and you should
     *         either modify your lifecycle settings or use a different vault. The longest maximum retention period you
     *         can specify is 36500 days (approximately 100 years). Recovery points already saved in the vault prior to
     *         Vault Lock are not affected.
     */
    public final Long maxRetentionDays() {
        return maxRetentionDays;
    }

    /**
     * <p>
     * The Backup Vault Lock configuration that specifies the number of days before the lock date. For example, setting
     * <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm
     * UTC.
     * </p>
     * <p>
     * Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you
     * must set <code>ChangeableForDays</code> to 3 or greater.
     * </p>
     * <p>
     * Before the lock date, you can delete Vault Lock from the vault using
     * <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
     * <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes immutable and
     * cannot be changed or deleted.
     * </p>
     * <p>
     * If this parameter is not specified, you can delete Vault Lock from the vault using
     * <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
     * <code>PutBackupVaultLockConfiguration</code> at any time.
     * </p>
     * 
     * @return The Backup Vault Lock configuration that specifies the number of days before the lock date. For example,
     *         setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan.
     *         31, 2022 at 8pm UTC.</p>
     *         <p>
     *         Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable.
     *         Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.
     *         </p>
     *         <p>
     *         Before the lock date, you can delete Vault Lock from the vault using
     *         <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
     *         <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes
     *         immutable and cannot be changed or deleted.
     *         </p>
     *         <p>
     *         If this parameter is not specified, you can delete Vault Lock from the vault using
     *         <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
     *         <code>PutBackupVaultLockConfiguration</code> at any time.
     */
    public final Long changeableForDays() {
        return changeableForDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(minRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(changeableForDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupVaultLockConfigurationRequest)) {
            return false;
        }
        PutBackupVaultLockConfigurationRequest other = (PutBackupVaultLockConfigurationRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(minRetentionDays(), other.minRetentionDays())
                && Objects.equals(maxRetentionDays(), other.maxRetentionDays())
                && Objects.equals(changeableForDays(), other.changeableForDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBackupVaultLockConfigurationRequest").add("BackupVaultName", backupVaultName())
                .add("MinRetentionDays", minRetentionDays()).add("MaxRetentionDays", maxRetentionDays())
                .add("ChangeableForDays", changeableForDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "MinRetentionDays":
            return Optional.ofNullable(clazz.cast(minRetentionDays()));
        case "MaxRetentionDays":
            return Optional.ofNullable(clazz.cast(maxRetentionDays()));
        case "ChangeableForDays":
            return Optional.ofNullable(clazz.cast(changeableForDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBackupVaultLockConfigurationRequest, T> g) {
        return obj -> g.apply((PutBackupVaultLockConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutBackupVaultLockConfigurationRequest> {
        /**
         * <p>
         * The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
         * </p>
         * 
         * @param backupVaultName
         *        The Backup Vault Lock configuration that specifies the name of the backup vault it protects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its
         * recovery points. This setting can be useful if, for example, your organization's policies require you to
         * retain certain data for at least seven years (2555 days).
         * </p>
         * <p>
         * If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
         * </p>
         * <p>
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a
         * retention period equal to or longer than the minimum retention period. If the job's retention period is
         * shorter than that minimum retention period, then the vault fails that backup or copy job, and you should
         * either modify your lifecycle settings or use a different vault. The shortest minimum retention period you can
         * specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are not affected.
         * </p>
         * 
         * @param minRetentionDays
         *        The Backup Vault Lock configuration that specifies the minimum retention period that the vault retains
         *        its recovery points. This setting can be useful if, for example, your organization's policies require
         *        you to retain certain data for at least seven years (2555 days).</p>
         *        <p>
         *        If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
         *        </p>
         *        <p>
         *        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with
         *        a retention period equal to or longer than the minimum retention period. If the job's retention period
         *        is shorter than that minimum retention period, then the vault fails that backup or copy job, and you
         *        should either modify your lifecycle settings or use a different vault. The shortest minimum retention
         *        period you can specify is 1 day. Recovery points already saved in the vault prior to Vault Lock are
         *        not affected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minRetentionDays(Long minRetentionDays);

        /**
         * <p>
         * The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its
         * recovery points. This setting can be useful if, for example, your organization's policies require you to
         * destroy certain data after retaining it for four years (1460 days).
         * </p>
         * <p>
         * If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery
         * points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum
         * retention period.
         * </p>
         * <p>
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a
         * retention period equal to or shorter than the maximum retention period. If the job's retention period is
         * longer than that maximum retention period, then the vault fails the backup or copy job, and you should either
         * modify your lifecycle settings or use a different vault. The longest maximum retention period you can specify
         * is 36500 days (approximately 100 years). Recovery points already saved in the vault prior to Vault Lock are
         * not affected.
         * </p>
         * 
         * @param maxRetentionDays
         *        The Backup Vault Lock configuration that specifies the maximum retention period that the vault retains
         *        its recovery points. This setting can be useful if, for example, your organization's policies require
         *        you to destroy certain data after retaining it for four years (1460 days).</p>
         *        <p>
         *        If this parameter is not included, Vault Lock does not enforce a maximum retention period on the
         *        recovery points in the vault. If this parameter is included without a value, Vault Lock will not
         *        enforce a maximum retention period.
         *        </p>
         *        <p>
         *        If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with
         *        a retention period equal to or shorter than the maximum retention period. If the job's retention
         *        period is longer than that maximum retention period, then the vault fails the backup or copy job, and
         *        you should either modify your lifecycle settings or use a different vault. The longest maximum
         *        retention period you can specify is 36500 days (approximately 100 years). Recovery points already
         *        saved in the vault prior to Vault Lock are not affected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetentionDays(Long maxRetentionDays);

        /**
         * <p>
         * The Backup Vault Lock configuration that specifies the number of days before the lock date. For example,
         * setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31,
         * 2022 at 8pm UTC.
         * </p>
         * <p>
         * Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore,
         * you must set <code>ChangeableForDays</code> to 3 or greater.
         * </p>
         * <p>
         * Before the lock date, you can delete Vault Lock from the vault using
         * <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
         * <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes immutable
         * and cannot be changed or deleted.
         * </p>
         * <p>
         * If this parameter is not specified, you can delete Vault Lock from the vault using
         * <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
         * <code>PutBackupVaultLockConfiguration</code> at any time.
         * </p>
         * 
         * @param changeableForDays
         *        The Backup Vault Lock configuration that specifies the number of days before the lock date. For
         *        example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock
         *        date to Jan. 31, 2022 at 8pm UTC.</p>
         *        <p>
         *        Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable.
         *        Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.
         *        </p>
         *        <p>
         *        Before the lock date, you can delete Vault Lock from the vault using
         *        <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
         *        <code>PutBackupVaultLockConfiguration</code>. On and after the lock date, the Vault Lock becomes
         *        immutable and cannot be changed or deleted.
         *        </p>
         *        <p>
         *        If this parameter is not specified, you can delete Vault Lock from the vault using
         *        <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using
         *        <code>PutBackupVaultLockConfiguration</code> at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeableForDays(Long changeableForDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private Long minRetentionDays;

        private Long maxRetentionDays;

        private Long changeableForDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupVaultLockConfigurationRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            minRetentionDays(model.minRetentionDays);
            maxRetentionDays(model.maxRetentionDays);
            changeableForDays(model.changeableForDays);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        @Transient
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Long getMinRetentionDays() {
            return minRetentionDays;
        }

        public final void setMinRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
        }

        @Override
        @Transient
        public final Builder minRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        public final Long getMaxRetentionDays() {
            return maxRetentionDays;
        }

        public final void setMaxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
        }

        @Override
        @Transient
        public final Builder maxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        public final Long getChangeableForDays() {
            return changeableForDays;
        }

        public final void setChangeableForDays(Long changeableForDays) {
            this.changeableForDays = changeableForDays;
        }

        @Override
        @Transient
        public final Builder changeableForDays(Long changeableForDays) {
            this.changeableForDays = changeableForDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBackupVaultLockConfigurationRequest build() {
            return new PutBackupVaultLockConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
