/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCopyJobRequest extends BackupRequest implements
        ToCopyableBuilder<StartCopyJobRequest.Builder, StartCopyJobRequest> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(StartCopyJobRequest::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackupVaultName").getter(getter(StartCopyJobRequest::sourceBackupVaultName))
            .setter(setter(Builder::sourceBackupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultName").build())
            .build();

    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationBackupVaultArn").getter(getter(StartCopyJobRequest::destinationBackupVaultArn))
            .setter(setter(Builder::destinationBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build())
            .build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(StartCopyJobRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(StartCopyJobRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .memberName("Lifecycle").getter(getter(StartCopyJobRequest::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            SOURCE_BACKUP_VAULT_NAME_FIELD, DESTINATION_BACKUP_VAULT_ARN_FIELD, IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD,
            LIFECYCLE_FIELD));

    private final String recoveryPointArn;

    private final String sourceBackupVaultName;

    private final String destinationBackupVaultArn;

    private final String iamRoleArn;

    private final String idempotencyToken;

    private final Lifecycle lifecycle;

    private StartCopyJobRequest(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.sourceBackupVaultName = builder.sourceBackupVaultName;
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point to use for the copy job; for example,
     * arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point to use for the copy job; for example,
     *         arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The name of a logical source container where backups are stored. Backup vaults are identified by names that are
     * unique to the account used to create them and the Amazon Web Services Region where they are created. They consist
     * of lowercase letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical source container where backups are stored. Backup vaults are identified by names
     *         that are unique to the account used to create them and the Amazon Web Services Region where they are
     *         created. They consist of lowercase letters, numbers, and hyphens.
     */
    public final String sourceBackupVaultName() {
        return sourceBackupVaultName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for
     *         example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public final String destinationBackupVaultArn() {
        return destinationBackupVaultArn;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to copy the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to copy the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a success
     * message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a
     *         success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * Returns the value of the Lifecycle property for this object.
     * 
     * @return The value of the Lifecycle property for this object.
     */
    public final Lifecycle lifecycle() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCopyJobRequest)) {
            return false;
        }
        StartCopyJobRequest other = (StartCopyJobRequest) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(sourceBackupVaultName(), other.sourceBackupVaultName())
                && Objects.equals(destinationBackupVaultArn(), other.destinationBackupVaultArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(idempotencyToken(), other.idempotencyToken()) && Objects.equals(lifecycle(), other.lifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCopyJobRequest").add("RecoveryPointArn", recoveryPointArn())
                .add("SourceBackupVaultName", sourceBackupVaultName())
                .add("DestinationBackupVaultArn", destinationBackupVaultArn()).add("IamRoleArn", iamRoleArn())
                .add("IdempotencyToken", idempotencyToken()).add("Lifecycle", lifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "SourceBackupVaultName":
            return Optional.ofNullable(clazz.cast(sourceBackupVaultName()));
        case "DestinationBackupVaultArn":
            return Optional.ofNullable(clazz.cast(destinationBackupVaultArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCopyJobRequest, T> g) {
        return obj -> g.apply((StartCopyJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCopyJobRequest> {
        /**
         * <p>
         * An ARN that uniquely identifies a recovery point to use for the copy job; for example,
         * arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point to use for the copy job; for example,
         *        arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The name of a logical source container where backups are stored. Backup vaults are identified by names that
         * are unique to the account used to create them and the Amazon Web Services Region where they are created. They
         * consist of lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param sourceBackupVaultName
         *        The name of a logical source container where backups are stored. Backup vaults are identified by names
         *        that are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created. They consist of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupVaultName(String sourceBackupVaultName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param destinationBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for
         *        example, <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBackupVaultArn(String destinationBackupVaultArn);

        /**
         * <p>
         * Specifies the IAM role ARN used to copy the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to copy the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a success
         * message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>StartCopyJob</code>. Retrying a successful request with the same idempotency token results in a
         *        success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * Sets the value of the Lifecycle property for this object.
         *
         * @param lifecycle
         *        The new value for the Lifecycle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * Sets the value of the Lifecycle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Lifecycle.Builder} avoiding the need to
         * create one manually via {@link Lifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String sourceBackupVaultName;

        private String destinationBackupVaultArn;

        private String iamRoleArn;

        private String idempotencyToken;

        private Lifecycle lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCopyJobRequest model) {
            super(model);
            recoveryPointArn(model.recoveryPointArn);
            sourceBackupVaultName(model.sourceBackupVaultName);
            destinationBackupVaultArn(model.destinationBackupVaultArn);
            iamRoleArn(model.iamRoleArn);
            idempotencyToken(model.idempotencyToken);
            lifecycle(model.lifecycle);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        @Transient
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getSourceBackupVaultName() {
            return sourceBackupVaultName;
        }

        public final void setSourceBackupVaultName(String sourceBackupVaultName) {
            this.sourceBackupVaultName = sourceBackupVaultName;
        }

        @Override
        @Transient
        public final Builder sourceBackupVaultName(String sourceBackupVaultName) {
            this.sourceBackupVaultName = sourceBackupVaultName;
            return this;
        }

        public final String getDestinationBackupVaultArn() {
            return destinationBackupVaultArn;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        @Override
        @Transient
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        @Transient
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        @Transient
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCopyJobRequest build() {
            return new StartCopyJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
