/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGlobalSettingsResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeGlobalSettingsResponse.Builder, DescribeGlobalSettingsResponse> {
    private static final SdkField<Map<String, String>> GLOBAL_SETTINGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("GlobalSettings")
            .getter(getter(DescribeGlobalSettingsResponse::globalSettings))
            .setter(setter(Builder::globalSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSettings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(DescribeGlobalSettingsResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_SETTINGS_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private final Map<String, String> globalSettings;

    private final Instant lastUpdateTime;

    private DescribeGlobalSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.globalSettings = builder.globalSettings;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * Returns true if the GlobalSettings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGlobalSettings() {
        return globalSettings != null && !(globalSettings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of resources along with the opt-in preferences for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resources along with the opt-in preferences for the account.
     */
    public final Map<String, String> globalSettings() {
        return globalSettings;
    }

    /**
     * <p>
     * The date and time that the global settings were last updated. This update is in Unix format and Coordinated
     * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
     * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the global settings were last updated. This update is in Unix format and
     *         Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSettings() ? globalSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalSettingsResponse)) {
            return false;
        }
        DescribeGlobalSettingsResponse other = (DescribeGlobalSettingsResponse) obj;
        return hasGlobalSettings() == other.hasGlobalSettings() && Objects.equals(globalSettings(), other.globalSettings())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGlobalSettingsResponse")
                .add("GlobalSettings", hasGlobalSettings() ? globalSettings() : null).add("LastUpdateTime", lastUpdateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalSettings":
            return Optional.ofNullable(clazz.cast(globalSettings()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalSettingsResponse, T> g) {
        return obj -> g.apply((DescribeGlobalSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGlobalSettingsResponse> {
        /**
         * <p>
         * A list of resources along with the opt-in preferences for the account.
         * </p>
         * 
         * @param globalSettings
         *        A list of resources along with the opt-in preferences for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSettings(Map<String, String> globalSettings);

        /**
         * <p>
         * The date and time that the global settings were last updated. This update is in Unix format and Coordinated
         * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
         * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time that the global settings were last updated. This update is in Unix format and
         *        Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to
         *        milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
         *        AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Map<String, String> globalSettings = DefaultSdkAutoConstructMap.getInstance();

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalSettingsResponse model) {
            super(model);
            globalSettings(model.globalSettings);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final Map<String, String> getGlobalSettings() {
            if (globalSettings instanceof SdkAutoConstructMap) {
                return null;
            }
            return globalSettings;
        }

        public final void setGlobalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
        }

        @Override
        @Transient
        public final Builder globalSettings(Map<String, String> globalSettings) {
            this.globalSettings = GlobalSettingsCopier.copy(globalSettings);
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public DescribeGlobalSettingsResponse build() {
            return new DescribeGlobalSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
