/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackupPlanResponse extends BackupResponse implements
        ToCopyableBuilder<UpdateBackupPlanResponse.Builder, UpdateBackupPlanResponse> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(UpdateBackupPlanResponse::backupPlanId))
            .setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanArn").getter(getter(UpdateBackupPlanResponse::backupPlanArn))
            .setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(UpdateBackupPlanResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(UpdateBackupPlanResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField
            .<List<AdvancedBackupSetting>> builder(MarshallingType.LIST)
            .memberName("AdvancedBackupSettings")
            .getter(getter(UpdateBackupPlanResponse::advancedBackupSettings))
            .setter(setter(Builder::advancedBackupSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedBackupSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedBackupSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            BACKUP_PLAN_ARN_FIELD, CREATION_DATE_FIELD, VERSION_ID_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));

    private final String backupPlanId;

    private final String backupPlanArn;

    private final Instant creationDate;

    private final String versionId;

    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private UpdateBackupPlanResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.creationDate = builder.creationDate;
        this.versionId = builder.versionId;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     */
    public final String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * The date and time a backup plan is updated, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a backup plan is updated, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids cannot
     * be edited.
     * </p>
     * 
     * @return Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids
     *         cannot be edited.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * Returns true if the AdvancedBackupSettings property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdvancedBackupSettings() {
        return advancedBackupSettings != null && !(advancedBackupSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of <code>BackupOptions</code> for each resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdvancedBackupSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a list of <code>BackupOptions</code> for each resource type.
     */
    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return advancedBackupSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedBackupSettings() ? advancedBackupSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackupPlanResponse)) {
            return false;
        }
        UpdateBackupPlanResponse other = (UpdateBackupPlanResponse) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(backupPlanArn(), other.backupPlanArn())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(versionId(), other.versionId())
                && hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings()
                && Objects.equals(advancedBackupSettings(), other.advancedBackupSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackupPlanResponse").add("BackupPlanId", backupPlanId())
                .add("BackupPlanArn", backupPlanArn()).add("CreationDate", creationDate()).add("VersionId", versionId())
                .add("AdvancedBackupSettings", hasAdvancedBackupSettings() ? advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "AdvancedBackupSettings":
            return Optional.ofNullable(clazz.cast(advancedBackupSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackupPlanResponse, T> g) {
        return obj -> g.apply((UpdateBackupPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBackupPlanResponse> {
        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * The date and time a backup plan is updated, in Unix format and Coordinated Universal Time (UTC). The value of
         * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a backup plan is updated, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version Ids
         * cannot be edited.
         * </p>
         * 
         * @param versionId
         *        Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version
         *        Ids cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        Contains a list of <code>BackupOptions</code> for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings);

        /**
         * <p>
         * Contains a list of <code>BackupOptions</code> for each resource type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdvancedBackupSetting>.Builder} avoiding
         * the need to create one manually via {@link List<AdvancedBackupSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdvancedBackupSetting>.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedBackupSettings(List<AdvancedBackupSetting>)}.
         * 
         * @param advancedBackupSettings
         *        a consumer that will call methods on {@link List<AdvancedBackupSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedBackupSettings(List<AdvancedBackupSetting>)
         */
        Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupPlanId;

        private String backupPlanArn;

        private Instant creationDate;

        private String versionId;

        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackupPlanResponse model) {
            super(model);
            backupPlanId(model.backupPlanId);
            backupPlanArn(model.backupPlanArn);
            creationDate(model.creationDate);
            versionId(model.versionId);
            advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        @Transient
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        @Transient
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        @Transient
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final List<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            List<AdvancedBackupSetting.Builder> result = AdvancedBackupSettingsCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        @Transient
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting... advancedBackupSettings) {
            advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder>... advancedBackupSettings) {
            advancedBackupSettings(Stream.of(advancedBackupSettings)
                    .map(c -> AdvancedBackupSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateBackupPlanResponse build() {
            return new UpdateBackupPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
