/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecoveryPointLifecycleResponse extends BackupResponse implements
        ToCopyableBuilder<UpdateRecoveryPointLifecycleResponse.Builder, UpdateRecoveryPointLifecycleResponse> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(UpdateRecoveryPointLifecycleResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(UpdateRecoveryPointLifecycleResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .memberName("Lifecycle").getter(getter(UpdateRecoveryPointLifecycleResponse::lifecycle))
            .setter(setter(Builder::lifecycle)).constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField
            .<CalculatedLifecycle> builder(MarshallingType.SDK_POJO).memberName("CalculatedLifecycle")
            .getter(getter(UpdateRecoveryPointLifecycleResponse::calculatedLifecycle))
            .setter(setter(Builder::calculatedLifecycle)).constructor(CalculatedLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD,
            RECOVERY_POINT_ARN_FIELD, LIFECYCLE_FIELD, CALCULATED_LIFECYCLE_FIELD));

    private final String backupVaultArn;

    private final String recoveryPointArn;

    private final Lifecycle lifecycle;

    private final CalculatedLifecycle calculatedLifecycle;

    private UpdateRecoveryPointLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.lifecycle = builder.lifecycle;
        this.calculatedLifecycle = builder.calculatedLifecycle;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
     * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Only Amazon EFS file system backups can be transitioned to cold storage.
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
     *         Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
     *         <p>
     *         Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     *         the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting.
     *         The “transition to cold after days” setting cannot be changed after a backup has been transitioned to
     *         cold.
     *         </p>
     *         <p>
     *         Only Amazon EFS file system backups can be transitioned to cold storage.
     */
    public final Lifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @return A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *         <code>MoveToColdStorageAt</code> timestamps.
     */
    public final CalculatedLifecycle calculatedLifecycle() {
        return calculatedLifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedLifecycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointLifecycleResponse)) {
            return false;
        }
        UpdateRecoveryPointLifecycleResponse other = (UpdateRecoveryPointLifecycleResponse) obj;
        return Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(lifecycle(), other.lifecycle())
                && Objects.equals(calculatedLifecycle(), other.calculatedLifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecoveryPointLifecycleResponse").add("BackupVaultArn", backupVaultArn())
                .add("RecoveryPointArn", recoveryPointArn()).add("Lifecycle", lifecycle())
                .add("CalculatedLifecycle", calculatedLifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "CalculatedLifecycle":
            return Optional.ofNullable(clazz.cast(calculatedLifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointLifecycleResponse, T> g) {
        return obj -> g.apply((UpdateRecoveryPointLifecycleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecoveryPointLifecycleResponse> {
        /**
         * <p>
         * An ARN that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * <p>
         * Only Amazon EFS file system backups can be transitioned to cold storage.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         *        AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
         *        </p>
         *        <p>
         *        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         *        Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after
         *        days” setting. The “transition to cold after days” setting cannot be changed after a backup has been
         *        transitioned to cold.
         *        </p>
         *        <p>
         *        Only Amazon EFS file system backups can be transitioned to cold storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * <p>
         * Only Amazon EFS file system backups can be transitioned to cold storage.
         * </p>
         * This is a convenience that creates an instance of the {@link Lifecycle.Builder} avoiding the need to create
         * one manually via {@link Lifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * 
         * @param calculatedLifecycle
         *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         *        <code>MoveToColdStorageAt</code> timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * This is a convenience that creates an instance of the {@link CalculatedLifecycle.Builder} avoiding the need
         * to create one manually via {@link CalculatedLifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link CalculatedLifecycle.Builder#build()} is called immediately and
         * its result is passed to {@link #calculatedLifecycle(CalculatedLifecycle)}.
         * 
         * @param calculatedLifecycle
         *        a consumer that will call methods on {@link CalculatedLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedLifecycle(CalculatedLifecycle)
         */
        default Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return calculatedLifecycle(CalculatedLifecycle.builder().applyMutation(calculatedLifecycle).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupVaultArn;

        private String recoveryPointArn;

        private Lifecycle lifecycle;

        private CalculatedLifecycle calculatedLifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointLifecycleResponse model) {
            super(model);
            backupVaultArn(model.backupVaultArn);
            recoveryPointArn(model.recoveryPointArn);
            lifecycle(model.lifecycle);
            calculatedLifecycle(model.calculatedLifecycle);
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        @Transient
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        @Transient
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        @Transient
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return calculatedLifecycle != null ? calculatedLifecycle.toBuilder() : null;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        @Override
        @Transient
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        @Override
        public UpdateRecoveryPointLifecycleResponse build() {
            return new UpdateRecoveryPointLifecycleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
