/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupSelectionRequest extends BackupRequest implements
        ToCopyableBuilder<CreateBackupSelectionRequest.Builder, CreateBackupSelectionRequest> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(CreateBackupSelectionRequest::backupPlanId))
            .setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupPlanId").build()).build();

    private static final SdkField<BackupSelection> BACKUP_SELECTION_FIELD = SdkField
            .<BackupSelection> builder(MarshallingType.SDK_POJO).memberName("BackupSelection")
            .getter(getter(CreateBackupSelectionRequest::backupSelection)).setter(setter(Builder::backupSelection))
            .constructor(BackupSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSelection").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateBackupSelectionRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            BACKUP_SELECTION_FIELD, CREATOR_REQUEST_ID_FIELD));

    private final String backupPlanId;

    private final BackupSelection backupSelection;

    private final String creatorRequestId;

    private CreateBackupSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupSelection = builder.backupSelection;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     * </p>
     * 
     * @return Uniquely identifies the backup plan to be associated with the selection of resources.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * Specifies the body of a request to assign a set of resources to a backup plan.
     * </p>
     * 
     * @return Specifies the body of a request to assign a set of resources to a backup plan.
     */
    public final BackupSelection backupSelection() {
        return backupSelection;
    }

    /**
     * <p>
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running
     * the operation twice. This parameter is optional.
     * </p>
     * <p>
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return A unique string that identifies the request and allows failed requests to be retried without the risk of
     *         running the operation twice. This parameter is optional.</p>
     *         <p>
     *         If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupSelection());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupSelectionRequest)) {
            return false;
        }
        CreateBackupSelectionRequest other = (CreateBackupSelectionRequest) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(backupSelection(), other.backupSelection())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackupSelectionRequest").add("BackupPlanId", backupPlanId())
                .add("BackupSelection", backupSelection()).add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupSelection":
            return Optional.ofNullable(clazz.cast(backupSelection()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupSelectionRequest, T> g) {
        return obj -> g.apply((CreateBackupSelectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupSelectionRequest> {
        /**
         * <p>
         * Uniquely identifies the backup plan to be associated with the selection of resources.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies the backup plan to be associated with the selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * Specifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * 
         * @param backupSelection
         *        Specifies the body of a request to assign a set of resources to a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSelection(BackupSelection backupSelection);

        /**
         * <p>
         * Specifies the body of a request to assign a set of resources to a backup plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupSelection.Builder} avoiding the
         * need to create one manually via {@link BackupSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #backupSelection(BackupSelection)}.
         * 
         * @param backupSelection
         *        a consumer that will call methods on {@link BackupSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupSelection(BackupSelection)
         */
        default Builder backupSelection(Consumer<BackupSelection.Builder> backupSelection) {
            return backupSelection(BackupSelection.builder().applyMutation(backupSelection).build());
        }

        /**
         * <p>
         * A unique string that identifies the request and allows failed requests to be retried without the risk of
         * running the operation twice. This parameter is optional.
         * </p>
         * <p>
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and allows failed requests to be retried without the risk
         *        of running the operation twice. This parameter is optional.</p>
         *        <p>
         *        If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupPlanId;

        private BackupSelection backupSelection;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupSelectionRequest model) {
            super(model);
            backupPlanId(model.backupPlanId);
            backupSelection(model.backupSelection);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final BackupSelection.Builder getBackupSelection() {
            return backupSelection != null ? backupSelection.toBuilder() : null;
        }

        public final void setBackupSelection(BackupSelection.BuilderImpl backupSelection) {
            this.backupSelection = backupSelection != null ? backupSelection.build() : null;
        }

        @Override
        public final Builder backupSelection(BackupSelection backupSelection) {
            this.backupSelection = backupSelection;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupSelectionRequest build() {
            return new CreateBackupSelectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
