/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a report job. A report job compiles a report based on a report plan and publishes
 * it to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportJob implements SdkPojo, Serializable, ToCopyableBuilder<ReportJob.Builder, ReportJob> {
    private static final SdkField<String> REPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportJobId").getter(getter(ReportJob::reportJobId)).setter(setter(Builder::reportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportJobId").build()).build();

    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanArn").getter(getter(ReportJob::reportPlanArn)).setter(setter(Builder::reportPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()).build();

    private static final SdkField<String> REPORT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportTemplate").getter(getter(ReportJob::reportTemplate)).setter(setter(Builder::reportTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTemplate").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ReportJob::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(ReportJob::completionTime)).setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReportJob::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ReportJob::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<ReportDestination> REPORT_DESTINATION_FIELD = SdkField
            .<ReportDestination> builder(MarshallingType.SDK_POJO).memberName("ReportDestination")
            .getter(getter(ReportJob::reportDestination)).setter(setter(Builder::reportDestination))
            .constructor(ReportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOB_ID_FIELD,
            REPORT_PLAN_ARN_FIELD, REPORT_TEMPLATE_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, REPORT_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportJobId;

    private final String reportPlanArn;

    private final String reportTemplate;

    private final Instant creationTime;

    private final Instant completionTime;

    private final String status;

    private final String statusMessage;

    private final ReportDestination reportDestination;

    private ReportJob(BuilderImpl builder) {
        this.reportJobId = builder.reportJobId;
        this.reportPlanArn = builder.reportPlanArn;
        this.reportTemplate = builder.reportTemplate;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.reportDestination = builder.reportDestination;
    }

    /**
     * <p>
     * The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most
     * 1,024 bytes long. Report job IDs cannot be edited.
     * </p>
     * 
     * @return The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at
     *         most 1,024 bytes long. Report job IDs cannot be edited.
     */
    public final String reportJobId() {
        return reportJobId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String reportPlanArn() {
        return reportPlanArn;
    }

    /**
     * <p>
     * Identifies the report template for the report. Reports are built using a report template. The report templates
     * are:
     * </p>
     * <p>
     * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * </p>
     * 
     * @return Identifies the report template for the report. Reports are built using a report template. The report
     *         templates are: </p>
     *         <p>
     *         <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     */
    public final String reportTemplate() {
        return reportTemplate;
    }

    /**
     * <p>
     * The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The status of a report job. The statuses are:
     * </p>
     * <p>
     * <code>CREATED | RUNNING | COMPLETED | FAILED</code>
     * </p>
     * <p>
     * <code>COMPLETED</code> means that the report is available for your review at your designated destination. If the
     * status is <code>FAILED</code>, review the <code>StatusMessage</code> for the reason.
     * </p>
     * 
     * @return The status of a report job. The statuses are:</p>
     *         <p>
     *         <code>CREATED | RUNNING | COMPLETED | FAILED</code>
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> means that the report is available for your review at your designated destination.
     *         If the status is <code>FAILED</code>, review the <code>StatusMessage</code> for the reason.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A message explaining the status of the report job.
     * </p>
     * 
     * @return A message explaining the status of the report job.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The S3 bucket name and S3 keys for the destination where the report job publishes the report.
     * </p>
     * 
     * @return The S3 bucket name and S3 keys for the destination where the report job publishes the report.
     */
    public final ReportDestination reportDestination() {
        return reportDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(reportTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(reportDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportJob)) {
            return false;
        }
        ReportJob other = (ReportJob) obj;
        return Objects.equals(reportJobId(), other.reportJobId()) && Objects.equals(reportPlanArn(), other.reportPlanArn())
                && Objects.equals(reportTemplate(), other.reportTemplate())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(status(), other.status())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(reportDestination(), other.reportDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportJob").add("ReportJobId", reportJobId()).add("ReportPlanArn", reportPlanArn())
                .add("ReportTemplate", reportTemplate()).add("CreationTime", creationTime())
                .add("CompletionTime", completionTime()).add("Status", status()).add("StatusMessage", statusMessage())
                .add("ReportDestination", reportDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportJobId":
            return Optional.ofNullable(clazz.cast(reportJobId()));
        case "ReportPlanArn":
            return Optional.ofNullable(clazz.cast(reportPlanArn()));
        case "ReportTemplate":
            return Optional.ofNullable(clazz.cast(reportTemplate()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ReportDestination":
            return Optional.ofNullable(clazz.cast(reportDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportJob, T> g) {
        return obj -> g.apply((ReportJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportJob> {
        /**
         * <p>
         * The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most
         * 1,024 bytes long. Report job IDs cannot be edited.
         * </p>
         * 
         * @param reportJobId
         *        The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is
         *        at most 1,024 bytes long. Report job IDs cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportJobId(String reportJobId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param reportPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanArn(String reportPlanArn);

        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * 
         * @param reportTemplate
         *        Identifies the report template for the report. Reports are built using a report template. The report
         *        templates are: </p>
         *        <p>
         *        <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportTemplate(String reportTemplate);

        /**
         * <p>
         * The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionTime
         *        The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The status of a report job. The statuses are:
         * </p>
         * <p>
         * <code>CREATED | RUNNING | COMPLETED | FAILED</code>
         * </p>
         * <p>
         * <code>COMPLETED</code> means that the report is available for your review at your designated destination. If
         * the status is <code>FAILED</code>, review the <code>StatusMessage</code> for the reason.
         * </p>
         * 
         * @param status
         *        The status of a report job. The statuses are:</p>
         *        <p>
         *        <code>CREATED | RUNNING | COMPLETED | FAILED</code>
         *        </p>
         *        <p>
         *        <code>COMPLETED</code> means that the report is available for your review at your designated
         *        destination. If the status is <code>FAILED</code>, review the <code>StatusMessage</code> for the
         *        reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A message explaining the status of the report job.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining the status of the report job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The S3 bucket name and S3 keys for the destination where the report job publishes the report.
         * </p>
         * 
         * @param reportDestination
         *        The S3 bucket name and S3 keys for the destination where the report job publishes the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDestination(ReportDestination reportDestination);

        /**
         * <p>
         * The S3 bucket name and S3 keys for the destination where the report job publishes the report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDestination.Builder} avoiding the
         * need to create one manually via {@link ReportDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #reportDestination(ReportDestination)}.
         * 
         * @param reportDestination
         *        a consumer that will call methods on {@link ReportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDestination(ReportDestination)
         */
        default Builder reportDestination(Consumer<ReportDestination.Builder> reportDestination) {
            return reportDestination(ReportDestination.builder().applyMutation(reportDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String reportJobId;

        private String reportPlanArn;

        private String reportTemplate;

        private Instant creationTime;

        private Instant completionTime;

        private String status;

        private String statusMessage;

        private ReportDestination reportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportJob model) {
            reportJobId(model.reportJobId);
            reportPlanArn(model.reportPlanArn);
            reportTemplate(model.reportTemplate);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            status(model.status);
            statusMessage(model.statusMessage);
            reportDestination(model.reportDestination);
        }

        public final String getReportJobId() {
            return reportJobId;
        }

        public final void setReportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
        }

        @Override
        public final Builder reportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
            return this;
        }

        public final String getReportPlanArn() {
            return reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final String getReportTemplate() {
            return reportTemplate;
        }

        public final void setReportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
        }

        @Override
        public final Builder reportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ReportDestination.Builder getReportDestination() {
            return reportDestination != null ? reportDestination.toBuilder() : null;
        }

        public final void setReportDestination(ReportDestination.BuilderImpl reportDestination) {
            this.reportDestination = reportDestination != null ? reportDestination.build() : null;
        }

        @Override
        public final Builder reportDestination(ReportDestination reportDestination) {
            this.reportDestination = reportDestination;
            return this;
        }

        @Override
        public ReportJob build() {
            return new ReportJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
