/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a report setting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportSetting implements SdkPojo, Serializable, ToCopyableBuilder<ReportSetting.Builder, ReportSetting> {
    private static final SdkField<String> REPORT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportTemplate").getter(getter(ReportSetting::reportTemplate)).setter(setter(Builder::reportTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTemplate").build()).build();

    private static final SdkField<List<String>> FRAMEWORK_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FrameworkArns")
            .getter(getter(ReportSetting::frameworkArns))
            .setter(setter(Builder::frameworkArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_FRAMEWORKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfFrameworks").getter(getter(ReportSetting::numberOfFrameworks))
            .setter(setter(Builder::numberOfFrameworks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFrameworks").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_TEMPLATE_FIELD,
            FRAMEWORK_ARNS_FIELD, NUMBER_OF_FRAMEWORKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportTemplate;

    private final List<String> frameworkArns;

    private final Integer numberOfFrameworks;

    private ReportSetting(BuilderImpl builder) {
        this.reportTemplate = builder.reportTemplate;
        this.frameworkArns = builder.frameworkArns;
        this.numberOfFrameworks = builder.numberOfFrameworks;
    }

    /**
     * <p>
     * Identifies the report template for the report. Reports are built using a report template. The report templates
     * are:
     * </p>
     * <p>
     * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * </p>
     * 
     * @return Identifies the report template for the report. Reports are built using a report template. The report
     *         templates are:</p>
     *         <p>
     *         <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     */
    public final String reportTemplate() {
        return reportTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the FrameworkArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrameworkArns() {
        return frameworkArns != null && !(frameworkArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the frameworks a report covers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameworkArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the frameworks a report covers.
     */
    public final List<String> frameworkArns() {
        return frameworkArns;
    }

    /**
     * <p>
     * The number of frameworks a report covers.
     * </p>
     * 
     * @return The number of frameworks a report covers.
     */
    public final Integer numberOfFrameworks() {
        return numberOfFrameworks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworkArns() ? frameworkArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfFrameworks());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportSetting)) {
            return false;
        }
        ReportSetting other = (ReportSetting) obj;
        return Objects.equals(reportTemplate(), other.reportTemplate()) && hasFrameworkArns() == other.hasFrameworkArns()
                && Objects.equals(frameworkArns(), other.frameworkArns())
                && Objects.equals(numberOfFrameworks(), other.numberOfFrameworks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportSetting").add("ReportTemplate", reportTemplate())
                .add("FrameworkArns", hasFrameworkArns() ? frameworkArns() : null)
                .add("NumberOfFrameworks", numberOfFrameworks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportTemplate":
            return Optional.ofNullable(clazz.cast(reportTemplate()));
        case "FrameworkArns":
            return Optional.ofNullable(clazz.cast(frameworkArns()));
        case "NumberOfFrameworks":
            return Optional.ofNullable(clazz.cast(numberOfFrameworks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportSetting, T> g) {
        return obj -> g.apply((ReportSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportSetting> {
        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * 
         * @param reportTemplate
         *        Identifies the report template for the report. Reports are built using a report template. The report
         *        templates are:</p>
         *        <p>
         *        <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportTemplate(String reportTemplate);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the frameworks a report covers.
         * </p>
         * 
         * @param frameworkArns
         *        The Amazon Resource Names (ARNs) of the frameworks a report covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkArns(Collection<String> frameworkArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the frameworks a report covers.
         * </p>
         * 
         * @param frameworkArns
         *        The Amazon Resource Names (ARNs) of the frameworks a report covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkArns(String... frameworkArns);

        /**
         * <p>
         * The number of frameworks a report covers.
         * </p>
         * 
         * @param numberOfFrameworks
         *        The number of frameworks a report covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfFrameworks(Integer numberOfFrameworks);
    }

    static final class BuilderImpl implements Builder {
        private String reportTemplate;

        private List<String> frameworkArns = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfFrameworks;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportSetting model) {
            reportTemplate(model.reportTemplate);
            frameworkArns(model.frameworkArns);
            numberOfFrameworks(model.numberOfFrameworks);
        }

        public final String getReportTemplate() {
            return reportTemplate;
        }

        public final void setReportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
        }

        @Override
        public final Builder reportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
            return this;
        }

        public final Collection<String> getFrameworkArns() {
            if (frameworkArns instanceof SdkAutoConstructList) {
                return null;
            }
            return frameworkArns;
        }

        public final void setFrameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
        }

        @Override
        public final Builder frameworkArns(Collection<String> frameworkArns) {
            this.frameworkArns = _stringListCopier.copy(frameworkArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkArns(String... frameworkArns) {
            frameworkArns(Arrays.asList(frameworkArns));
            return this;
        }

        public final Integer getNumberOfFrameworks() {
            return numberOfFrameworks;
        }

        public final void setNumberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
        }

        @Override
        public final Builder numberOfFrameworks(Integer numberOfFrameworks) {
            this.numberOfFrameworks = numberOfFrameworks;
            return this;
        }

        @Override
        public ReportSetting build() {
            return new ReportSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
