/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFrameworkResponse extends BackupResponse implements
        ToCopyableBuilder<UpdateFrameworkResponse.Builder, UpdateFrameworkResponse> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkName").getter(getter(UpdateFrameworkResponse::frameworkName))
            .setter(setter(Builder::frameworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()).build();

    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkArn").getter(getter(UpdateFrameworkResponse::frameworkArn))
            .setter(setter(Builder::frameworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(UpdateFrameworkResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD,
            FRAMEWORK_ARN_FIELD, CREATION_TIME_FIELD));

    private final String frameworkName;

    private final String frameworkArn;

    private final Instant creationTime;

    private UpdateFrameworkResponse(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting
     * of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
     *         consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String frameworkName() {
        return frameworkName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String frameworkArn() {
        return frameworkArn;
    }

    /**
     * <p>
     * The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFrameworkResponse)) {
            return false;
        }
        UpdateFrameworkResponse other = (UpdateFrameworkResponse) obj;
        return Objects.equals(frameworkName(), other.frameworkName()) && Objects.equals(frameworkArn(), other.frameworkArn())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFrameworkResponse").add("FrameworkName", frameworkName())
                .add("FrameworkArn", frameworkArn()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameworkName":
            return Optional.ofNullable(clazz.cast(frameworkName()));
        case "FrameworkArn":
            return Optional.ofNullable(clazz.cast(frameworkArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFrameworkResponse, T> g) {
        return obj -> g.apply((UpdateFrameworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFrameworkResponse> {
        /**
         * <p>
         * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param frameworkName
         *        The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         *        consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkName(String frameworkName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param frameworkArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkArn(String frameworkArn);

        /**
         * <p>
         * The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String frameworkName;

        private String frameworkArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFrameworkResponse model) {
            super(model);
            frameworkName(model.frameworkName);
            frameworkArn(model.frameworkArn);
            creationTime(model.creationTime);
        }

        public final String getFrameworkName() {
            return frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public UpdateFrameworkResponse build() {
            return new UpdateFrameworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
