/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;

public class ListBackupPlanTemplatesPublisher
implements SdkPublisher<ListBackupPlanTemplatesResponse> {
    private final BackupAsyncClient client;
    private final ListBackupPlanTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupPlanTemplatesPublisher(BackupAsyncClient client, ListBackupPlanTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupPlanTemplatesPublisher(BackupAsyncClient client, ListBackupPlanTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupPlanTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupPlanTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BackupPlanTemplatesListMember> backupPlanTemplatesList() {
        Function<ListBackupPlanTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupPlanTemplatesList() != null) {
                return response.backupPlanTemplatesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBackupPlanTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBackupPlanTemplatesResponseFetcher
    implements AsyncPageFetcher<ListBackupPlanTemplatesResponse> {
        private ListBackupPlanTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlanTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupPlanTemplatesResponse> nextPage(ListBackupPlanTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlanTemplatesPublisher.this.client.listBackupPlanTemplates(ListBackupPlanTemplatesPublisher.this.firstRequest);
            }
            return ListBackupPlanTemplatesPublisher.this.client.listBackupPlanTemplates((ListBackupPlanTemplatesRequest)((Object)ListBackupPlanTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

