/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a report plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportPlan implements SdkPojo, Serializable, ToCopyableBuilder<ReportPlan.Builder, ReportPlan> {
    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanArn").getter(getter(ReportPlan::reportPlanArn)).setter(setter(Builder::reportPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()).build();

    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanName").getter(getter(ReportPlan::reportPlanName)).setter(setter(Builder::reportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()).build();

    private static final SdkField<String> REPORT_PLAN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanDescription").getter(getter(ReportPlan::reportPlanDescription))
            .setter(setter(Builder::reportPlanDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanDescription").build())
            .build();

    private static final SdkField<ReportSetting> REPORT_SETTING_FIELD = SdkField
            .<ReportSetting> builder(MarshallingType.SDK_POJO).memberName("ReportSetting")
            .getter(getter(ReportPlan::reportSetting)).setter(setter(Builder::reportSetting)).constructor(ReportSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSetting").build()).build();

    private static final SdkField<ReportDeliveryChannel> REPORT_DELIVERY_CHANNEL_FIELD = SdkField
            .<ReportDeliveryChannel> builder(MarshallingType.SDK_POJO).memberName("ReportDeliveryChannel")
            .getter(getter(ReportPlan::reportDeliveryChannel)).setter(setter(Builder::reportDeliveryChannel))
            .constructor(ReportDeliveryChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDeliveryChannel").build())
            .build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(ReportPlan::deploymentStatus))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ReportPlan::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_ATTEMPTED_EXECUTION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAttemptedExecutionTime")
            .getter(getter(ReportPlan::lastAttemptedExecutionTime))
            .setter(setter(Builder::lastAttemptedExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAttemptedExecutionTime").build())
            .build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_EXECUTION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulExecutionTime")
            .getter(getter(ReportPlan::lastSuccessfulExecutionTime))
            .setter(setter(Builder::lastSuccessfulExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulExecutionTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_ARN_FIELD,
            REPORT_PLAN_NAME_FIELD, REPORT_PLAN_DESCRIPTION_FIELD, REPORT_SETTING_FIELD, REPORT_DELIVERY_CHANNEL_FIELD,
            DEPLOYMENT_STATUS_FIELD, CREATION_TIME_FIELD, LAST_ATTEMPTED_EXECUTION_TIME_FIELD,
            LAST_SUCCESSFUL_EXECUTION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportPlanArn;

    private final String reportPlanName;

    private final String reportPlanDescription;

    private final ReportSetting reportSetting;

    private final ReportDeliveryChannel reportDeliveryChannel;

    private final String deploymentStatus;

    private final Instant creationTime;

    private final Instant lastAttemptedExecutionTime;

    private final Instant lastSuccessfulExecutionTime;

    private ReportPlan(BuilderImpl builder) {
        this.reportPlanArn = builder.reportPlanArn;
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanDescription = builder.reportPlanDescription;
        this.reportSetting = builder.reportSetting;
        this.reportDeliveryChannel = builder.reportDeliveryChannel;
        this.deploymentStatus = builder.deploymentStatus;
        this.creationTime = builder.creationTime;
        this.lastAttemptedExecutionTime = builder.lastAttemptedExecutionTime;
        this.lastSuccessfulExecutionTime = builder.lastSuccessfulExecutionTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String reportPlanArn() {
        return reportPlanArn;
    }

    /**
     * <p>
     * The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and
     * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and
     *         consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String reportPlanName() {
        return reportPlanName;
    }

    /**
     * <p>
     * An optional description of the report plan with a maximum 1,024 characters.
     * </p>
     * 
     * @return An optional description of the report plan with a maximum 1,024 characters.
     */
    public final String reportPlanDescription() {
        return reportPlanDescription;
    }

    /**
     * <p>
     * Identifies the report template for the report. Reports are built using a report template. The report templates
     * are:
     * </p>
     * <p>
     * <code>BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * </p>
     * 
     * @return Identifies the report template for the report. Reports are built using a report template. The report
     *         templates are:</p>
     *         <p>
     *         <code>BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     */
    public final ReportSetting reportSetting() {
        return reportSetting;
    }

    /**
     * <p>
     * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key
     * prefix, and the formats of your reports.
     * </p>
     * 
     * @return Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket
     *         name, S3 key prefix, and the formats of your reports.
     */
    public final ReportDeliveryChannel reportDeliveryChannel() {
        return reportDeliveryChannel;
    }

    /**
     * <p>
     * The deployment status of a report plan. The statuses are:
     * </p>
     * <p>
     * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code>
     * </p>
     * 
     * @return The deployment status of a report plan. The statuses are:</p>
     *         <p>
     *         <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code>
     */
    public final String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that a report job associated with this report plan last attempted to run, in Unix format and
     * Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is accurate to
     * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a report job associated with this report plan last attempted to run, in Unix
     *         format and Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is
     *         accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
     *         12:11:30.087 AM.
     */
    public final Instant lastAttemptedExecutionTime() {
        return lastAttemptedExecutionTime;
    }

    /**
     * <p>
     * The date and time that a report job associated with this report plan last successfully ran, in Unix format and
     * Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is accurate to
     * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a report job associated with this report plan last successfully ran, in Unix
     *         format and Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is
     *         accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
     *         12:11:30.087 AM.
     */
    public final Instant lastSuccessfulExecutionTime() {
        return lastSuccessfulExecutionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanDescription());
        hashCode = 31 * hashCode + Objects.hashCode(reportSetting());
        hashCode = 31 * hashCode + Objects.hashCode(reportDeliveryChannel());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAttemptedExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulExecutionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportPlan)) {
            return false;
        }
        ReportPlan other = (ReportPlan) obj;
        return Objects.equals(reportPlanArn(), other.reportPlanArn()) && Objects.equals(reportPlanName(), other.reportPlanName())
                && Objects.equals(reportPlanDescription(), other.reportPlanDescription())
                && Objects.equals(reportSetting(), other.reportSetting())
                && Objects.equals(reportDeliveryChannel(), other.reportDeliveryChannel())
                && Objects.equals(deploymentStatus(), other.deploymentStatus())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastAttemptedExecutionTime(), other.lastAttemptedExecutionTime())
                && Objects.equals(lastSuccessfulExecutionTime(), other.lastSuccessfulExecutionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportPlan").add("ReportPlanArn", reportPlanArn()).add("ReportPlanName", reportPlanName())
                .add("ReportPlanDescription", reportPlanDescription()).add("ReportSetting", reportSetting())
                .add("ReportDeliveryChannel", reportDeliveryChannel()).add("DeploymentStatus", deploymentStatus())
                .add("CreationTime", creationTime()).add("LastAttemptedExecutionTime", lastAttemptedExecutionTime())
                .add("LastSuccessfulExecutionTime", lastSuccessfulExecutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlanArn":
            return Optional.ofNullable(clazz.cast(reportPlanArn()));
        case "ReportPlanName":
            return Optional.ofNullable(clazz.cast(reportPlanName()));
        case "ReportPlanDescription":
            return Optional.ofNullable(clazz.cast(reportPlanDescription()));
        case "ReportSetting":
            return Optional.ofNullable(clazz.cast(reportSetting()));
        case "ReportDeliveryChannel":
            return Optional.ofNullable(clazz.cast(reportDeliveryChannel()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastAttemptedExecutionTime":
            return Optional.ofNullable(clazz.cast(lastAttemptedExecutionTime()));
        case "LastSuccessfulExecutionTime":
            return Optional.ofNullable(clazz.cast(lastSuccessfulExecutionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportPlan, T> g) {
        return obj -> g.apply((ReportPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportPlan> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param reportPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanArn(String reportPlanArn);

        /**
         * <p>
         * The unique name of the report plan. This name is between 1 and 256 characters starting with a letter, and
         * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param reportPlanName
         *        The unique name of the report plan. This name is between 1 and 256 characters starting with a letter,
         *        and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanName(String reportPlanName);

        /**
         * <p>
         * An optional description of the report plan with a maximum 1,024 characters.
         * </p>
         * 
         * @param reportPlanDescription
         *        An optional description of the report plan with a maximum 1,024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanDescription(String reportPlanDescription);

        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * 
         * @param reportSetting
         *        Identifies the report template for the report. Reports are built using a report template. The report
         *        templates are:</p>
         *        <p>
         *        <code>BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportSetting(ReportSetting reportSetting);

        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * This is a convenience that creates an instance of the {@link ReportSetting.Builder} avoiding the need to
         * create one manually via {@link ReportSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #reportSetting(ReportSetting)}.
         * 
         * @param reportSetting
         *        a consumer that will call methods on {@link ReportSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportSetting(ReportSetting)
         */
        default Builder reportSetting(Consumer<ReportSetting.Builder> reportSetting) {
            return reportSetting(ReportSetting.builder().applyMutation(reportSetting).build());
        }

        /**
         * <p>
         * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3
         * key prefix, and the formats of your reports.
         * </p>
         * 
         * @param reportDeliveryChannel
         *        Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket
         *        name, S3 key prefix, and the formats of your reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel);

        /**
         * <p>
         * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3
         * key prefix, and the formats of your reports.
         * </p>
         * This is a convenience that creates an instance of the {@link ReportDeliveryChannel.Builder} avoiding the need
         * to create one manually via {@link ReportDeliveryChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportDeliveryChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #reportDeliveryChannel(ReportDeliveryChannel)}.
         * 
         * @param reportDeliveryChannel
         *        a consumer that will call methods on {@link ReportDeliveryChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDeliveryChannel(ReportDeliveryChannel)
         */
        default Builder reportDeliveryChannel(Consumer<ReportDeliveryChannel.Builder> reportDeliveryChannel) {
            return reportDeliveryChannel(ReportDeliveryChannel.builder().applyMutation(reportDeliveryChannel).build());
        }

        /**
         * <p>
         * The deployment status of a report plan. The statuses are:
         * </p>
         * <p>
         * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code>
         * </p>
         * 
         * @param deploymentStatus
         *        The deployment status of a report plan. The statuses are:</p>
         *        <p>
         *        <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a report plan is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that a report job associated with this report plan last attempted to run, in Unix format
         * and Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is accurate to
         * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastAttemptedExecutionTime
         *        The date and time that a report job associated with this report plan last attempted to run, in Unix
         *        format and Coordinated Universal Time (UTC). The value of <code>LastAttemptedExecutionTime</code> is
         *        accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
         *        12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAttemptedExecutionTime(Instant lastAttemptedExecutionTime);

        /**
         * <p>
         * The date and time that a report job associated with this report plan last successfully ran, in Unix format
         * and Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is accurate to
         * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastSuccessfulExecutionTime
         *        The date and time that a report job associated with this report plan last successfully ran, in Unix
         *        format and Coordinated Universal Time (UTC). The value of <code>LastSuccessfulExecutionTime</code> is
         *        accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
         *        12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulExecutionTime(Instant lastSuccessfulExecutionTime);
    }

    static final class BuilderImpl implements Builder {
        private String reportPlanArn;

        private String reportPlanName;

        private String reportPlanDescription;

        private ReportSetting reportSetting;

        private ReportDeliveryChannel reportDeliveryChannel;

        private String deploymentStatus;

        private Instant creationTime;

        private Instant lastAttemptedExecutionTime;

        private Instant lastSuccessfulExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportPlan model) {
            reportPlanArn(model.reportPlanArn);
            reportPlanName(model.reportPlanName);
            reportPlanDescription(model.reportPlanDescription);
            reportSetting(model.reportSetting);
            reportDeliveryChannel(model.reportDeliveryChannel);
            deploymentStatus(model.deploymentStatus);
            creationTime(model.creationTime);
            lastAttemptedExecutionTime(model.lastAttemptedExecutionTime);
            lastSuccessfulExecutionTime(model.lastSuccessfulExecutionTime);
        }

        public final String getReportPlanArn() {
            return reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        @Transient
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final String getReportPlanName() {
            return reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        @Transient
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanDescription() {
            return reportPlanDescription;
        }

        public final void setReportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
        }

        @Override
        @Transient
        public final Builder reportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        public final ReportSetting.Builder getReportSetting() {
            return reportSetting != null ? reportSetting.toBuilder() : null;
        }

        public final void setReportSetting(ReportSetting.BuilderImpl reportSetting) {
            this.reportSetting = reportSetting != null ? reportSetting.build() : null;
        }

        @Override
        @Transient
        public final Builder reportSetting(ReportSetting reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        public final ReportDeliveryChannel.Builder getReportDeliveryChannel() {
            return reportDeliveryChannel != null ? reportDeliveryChannel.toBuilder() : null;
        }

        public final void setReportDeliveryChannel(ReportDeliveryChannel.BuilderImpl reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel != null ? reportDeliveryChannel.build() : null;
        }

        @Override
        @Transient
        public final Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastAttemptedExecutionTime() {
            return lastAttemptedExecutionTime;
        }

        public final void setLastAttemptedExecutionTime(Instant lastAttemptedExecutionTime) {
            this.lastAttemptedExecutionTime = lastAttemptedExecutionTime;
        }

        @Override
        @Transient
        public final Builder lastAttemptedExecutionTime(Instant lastAttemptedExecutionTime) {
            this.lastAttemptedExecutionTime = lastAttemptedExecutionTime;
            return this;
        }

        public final Instant getLastSuccessfulExecutionTime() {
            return lastSuccessfulExecutionTime;
        }

        public final void setLastSuccessfulExecutionTime(Instant lastSuccessfulExecutionTime) {
            this.lastSuccessfulExecutionTime = lastSuccessfulExecutionTime;
        }

        @Override
        @Transient
        public final Builder lastSuccessfulExecutionTime(Instant lastSuccessfulExecutionTime) {
            this.lastSuccessfulExecutionTime = lastSuccessfulExecutionTime;
            return this;
        }

        @Override
        public ReportPlan build() {
            return new ReportPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
